/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.api.inkAction.InkActionUtil;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Translation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class ChangeDayTimeInkAction
extends InkAction {
    private String action;
    private long fromTick;
    private long toTick;
    private long segmentTick;
    private long currentTick;
    private long lastTick;
    private double forSeconds;
    private Easing easing;

    public ChangeDayTimeInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.canBeExecuted || !this.isRunning || this.easing == null) {
            return;
        }
        ++this.segmentTick;
    }

    @Override
    public void partialTick(float partialTick) {
        if (!this.canBeExecuted || !this.isRunning || this.easing == null) {
            return;
        }
        double durationTicks = this.forSeconds * 20.0;
        double t = Math.clamp((double)((float)this.segmentTick + partialTick) / durationTicks, 0.0, 1.0);
        this.currentTick = (long)class_3532.method_16436((double)t, (double)this.fromTick, (double)this.toTick);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Action set or add"));
        }
        this.action = arguments.get(1);
        if (!this.action.equals("set") && !this.action.equals("add")) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Only set or add as action"));
        }
        if (arguments.size() < 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Time day tick"));
        }
        this.currentTick = this.fromTick = this.getTickFromString(arguments.get(2));
        if (this.fromTick == -1L) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(2)));
        }
        if (this.action.equals("add") || arguments.size() == 3) {
            return InkActionResult.ok();
        }
        if (arguments.get(3).equals("to") && arguments.size() < 5) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Time day tick"));
        }
        this.toTick = this.getTickFromString(arguments.get(4));
        if (this.toTick == -1L) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(4)));
        }
        if (arguments.get(5).equals("for") && arguments.size() < 7) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "For seconds"));
        }
        try {
            this.forSeconds = Double.parseDouble(arguments.get(6));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", arguments.get(6)));
        }
        if (arguments.size() == 7) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_time_value", new Object[0]));
        }
        String timeValue = arguments.get(7);
        this.forSeconds = InkActionUtil.getSecondsFromTimeValue(this.forSeconds, timeValue);
        if (this.forSeconds == -1.0) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.number", this.forSeconds));
        }
        this.easing = Easing.SMOOTH;
        if (arguments.size() > 8) {
            try {
                this.easing = Easing.valueOf(arguments.get(8).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_easing_value", Arrays.toString((Object[])Easing.values())));
            }
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        for (InkAction inkAction : playerSession.getInkActions()) {
            if (!(inkAction instanceof ChangeDayTimeInkAction)) continue;
            ChangeDayTimeInkAction changeDayTimeInkAction = (ChangeDayTimeInkAction)inkAction;
            this.currentTick += changeDayTimeInkAction.getCurrentTick();
            changeDayTimeInkAction.setRunning(false);
        }
        return InkActionResult.ok();
    }

    private long getTickFromString(String dayTime) {
        String string = dayTime;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"day", "midnight", "night", "noon"}, (Object)string, n)) {
            case 0: {
                return 1000L;
            }
            case 1: {
                return 18000L;
            }
            case 2: {
                return 13000L;
            }
            case 3: {
                return 6000L;
            }
        }
        try {
            return Long.parseLong(dayTime);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

