#version 150 core

uniform int UseBrightLightmap;
uniform vec3 SkyLightColor;
uniform float NightVisionFactor;

in vec2 texCoord;

out vec4 fragColor;

void main() {
    vec3 color = vec3(1.0); // Standardmäßig komplett hell

    if (UseBrightLightmap == 0) {
        color = vec3(1.0) + SkyLightColor * 0.5; // Falls normale Lightmap, SkyLight leicht addieren
        color = clamp(color, 0.0, 1.0);
    }

    if (NightVisionFactor > 0.0) {
        float max_component = max(max(color.r, color.g), color.b);
        if (max_component < 1.0) {
            vec3 bright_color = color / max_component;
            color = mix(color, bright_color, NightVisionFactor);
        }
    }

    fragColor = vec4(color, 1.0);
}