/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.soulgauntlet.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.soulgauntlet.SoulGauntletMod;
import net.mcreator.soulgauntlet.procedures.Slot1PowerProcedure;
import net.mcreator.soulgauntlet.procedures.Slot2PowerProcedure;
import net.mcreator.soulgauntlet.procedures.Slot3PowerProcedure;
import net.mcreator.soulgauntlet.world.inventory.SlotSelect0Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SlotSelect0ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SlotSelect0ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SlotSelect0ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SlotSelect0ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SlotSelect0ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SlotSelect0ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SlotSelect0Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Slot1PowerProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Slot2PowerProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Slot3PowerProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoulGauntletMod.addNetworkMessage(SlotSelect0ButtonMessage.class, SlotSelect0ButtonMessage::buffer, SlotSelect0ButtonMessage::new, SlotSelect0ButtonMessage::handler);
    }
}

