/*
 * Decompiled with CFR 0.152.
 */
package me.darksoul.WITxAbyssalLib;

import com.github.darksoulq.wit.api.API;
import com.github.darksoulq.wit.api.WITPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import me.darksoul.WITxAbyssalLib.AbyssalLibHandler;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class WITAbyssalLib
extends JavaPlugin
implements WITPlugin {
    public static WITAbyssalLib INSTANCE;
    public static File CONFIG_FILE;
    public static YamlConfiguration CONFIG;

    public void onEnable() {
        INSTANCE = this;
        CONFIG_FILE = new File(this.getDataFolder(), "config.yml");
        if (!CONFIG_FILE.getParentFile().exists()) {
            CONFIG_FILE.getParentFile().mkdirs();
        }
        WITAbyssalLib.copyTemplate("config.yml", CONFIG_FILE);
        CONFIG = WITAbyssalLib.loadConfig();
        API.registerAddon((WITPlugin)this);
    }

    public void onDisable() {
    }

    public void onWITReload() {
        CONFIG = WITAbyssalLib.loadConfig();
        API.addBlockHandler(AbyssalLibHandler::handleBlock);
    }

    public static void copyTemplate(String resourceName, File destination) {
        if (!destination.exists()) {
            try (InputStream resourceStream = INSTANCE.getResource(resourceName);){
                if (resourceStream != null) {
                    Files.copy(resourceStream, destination.toPath(), new CopyOption[0]);
                } else {
                    destination.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static YamlConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
    }
}

