/*
 * Decompiled with CFR 0.152.
 */
package me.darksoul.WITxMinetorio;

import com.MT.xxxtrigger50xxx.Devices.Battery2;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.PowerGrid;
import com.MT.xxxtrigger50xxx.Technology.ResearchLab;
import com.github.darksoulq.wit.Information;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import me.darksoul.WITxMinetorio.ItemGroups;
import me.darksoul.WITxMinetorio.WITMinetorio;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Informations {
    private static final File LANG_FOLDER = new File(WITMinetorio.getInstance().getDataFolder(), "lang");
    public static File VALUES_FILE = new File(LANG_FOLDER, "values.yml");
    public static File CONFIG_FILE = new File(WITMinetorio.getInstance().getDataFolder(), "config.yml");
    public static MiniMessage mm = MiniMessage.miniMessage();

    public static void setup() {
        if (!CONFIG_FILE.getParentFile().exists()) {
            CONFIG_FILE.getParentFile().mkdirs();
        }
        if (!LANG_FOLDER.exists()) {
            LANG_FOLDER.mkdirs();
        }
        Informations.copyTemplate("config.yml", CONFIG_FILE);
        Informations.copyTemplate("values.yml", VALUES_FILE);
    }

    public static Component getPower(Block block) {
        Device device = Device.getDevice((Block)block);
        if (device != null) {
            if (ItemGroups.isGenerator(device)) {
                if (device.isProducingPower()) {
                    return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.generator_power_gen_on", " \u00a7a\u26a1 {powerGen}").replace("{powerGen}", String.valueOf(device.getPowerGen())));
                }
                return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.generator_power_gen_off", " \u00a78\u26a1 0"));
            }
            if (device instanceof Battery2) {
                float fillPercentage = (float)((Battery2)device).getStored() / (float)((Battery2)device).getCapacity() * 100.0f;
                String color = Information.getColorForPercent((float)fillPercentage);
                String colorEnd = Information.getColorForPercentEnd((float)fillPercentage);
                return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.battery_stored_power", "{colorByPercent} \u26a1 {storedPower}").replace("{colorByPercent}", color).replace("{storedPower}", String.valueOf(((Battery2)device).getStored())).replace("{colorByPercentEnd}", colorEnd));
            }
            if (device.isNeedsPower() && device.isPowered()) {
                if (device.getIdlePower() == 0) {
                    return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.device_action_power_noidle", " \u00a7c\u26a1 {needsPower}").replace("{needsPower}", String.valueOf(device.getActionPower())));
                }
                return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.device_action_power", " \u00a7c\u26a1 {needsPowerIdle}").replace("{needsPowerIdle}", String.valueOf(device.getActionPower() / device.getIdlePower())));
            }
        }
        return Component.text((String)"");
    }

    public static Component containerInfo(Block block) {
        Device device = Device.getDevice((Block)block);
        if (device == null) {
            return Component.text((String)"");
        }
        ArrayList inputs = device.getInSlots();
        ArrayList outputs = device.getOutSlots();
        HashSet slots = new HashSet();
        slots.addAll(inputs);
        slots.addAll(outputs);
        if (inputs.isEmpty() && outputs.isEmpty()) {
            return Component.text((String)"");
        }
        Inventory inv = device.getInventory();
        if (inv == null) {
            return Component.text((String)"");
        }
        int amount = 0;
        Iterator iterator = slots.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ItemStack stack = inv.getItem(i);
            if (stack == null) continue;
            amount += stack.getAmount();
        }
        return mm.deserialize((Object)Information.getValuesFile().getString("minecraft.items_in_container", "\u00a76\ud83d\udce6 {items}\u00a7f ").replace("{items}", String.valueOf(amount)));
    }

    public static Component researchLabProgress(Block block) {
        Device device = Device.getDevice((Block)block);
        if (device != null && device instanceof ResearchLab) {
            ResearchLab lab = (ResearchLab)device;
            PlayerData data = PlayerData.getPlayerData((String)lab.getPlacerUUIDString());
            int progress = data.getTechProgression(data.getCurrentResearch());
            return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.lab_progress", " {colorByPercent}\ud83e\uddea {researchProgress}{colorByPercentEnd}").replace("{colorByPercent}", Information.getColorForPercent((float)progress)).replace("{researchProgress}", String.valueOf(progress)).replace("{colorByPercentEnd}", Information.getColorForPercentEnd((float)progress)));
        }
        return Component.text((String)"");
    }

    public static Component pylonGridConnections(Block block) {
        Device device = Device.getDevice((Block)block);
        if (device != null && device instanceof PowerPylon) {
            PowerGrid grid = device.getGrid();
            return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.pylon_connections", "<green>\u26d3 {connections}</green> ").replace("{connections}", String.valueOf(grid.deviceConnections.size())));
        }
        return Component.text((String)"");
    }

    public static Component getLiquidAmount(Block block) {
        Device device = Device.getDevice((Block)block);
        if (device != null) {
            ArrayList types = device.getLiquidTypes();
            if (types.isEmpty()) {
                return Component.text((String)"");
            }
            StringBuilder temp = new StringBuilder();
            for (Device.LiquidType type : types) {
                temp.append(Informations.emojiByLiquidType(type)).append(device.getStoredLiquid(type));
            }
            return mm.deserialize((Object)WITMinetorio.VALUES_CONFIG.getString("minetorio.device_liquid_amount", " $c{liquidAmounts}").replace("{liquidAmounts}", temp));
        }
        return Component.text((String)"");
    }

    private static String emojiByLiquidType(Device.LiquidType type) {
        switch (type) {
            case WATER: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_water", " <#2bbfd9>\ud83d\udca7</#2bbfd9>");
            }
            case OIL: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_oil", " <#1d1c1f>\ud83d\udca7</#1d1c1f>");
            }
            case STEAM: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_steam", " <white>\ud83d\udca8</white>");
            }
            case HEAVYOIL: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_heavyoil", " <#0c0b0d>\ud83d\udca7</#0c0b0d>");
            }
            case LIGHTOIL: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_lightoil", " <#2f2d33>\ud83d\udca7</#2f2d33>");
            }
            case PETROL: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_petrol", " <#303029>\ud83d\udca7</#303029>");
            }
            case LUBRICANT: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_lubricant", " <#392e3b>\ud83d\udca7</#392e3b>");
            }
            case SULFURIC_ACID: {
                return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_sulphuric_acid", " <#bec246>\ud83d\udca7</#bec246>");
            }
        }
        return WITMinetorio.VALUES_CONFIG.getString("emojis.liquid_type_water", " <#2bbfd9>\ud83d\udca7</#2bbfd9>");
    }

    public static void copyTemplate(String resourceName, File destination) {
        if (!destination.exists()) {
            try (InputStream resourceStream = WITMinetorio.getInstance().getResource(resourceName);){
                if (resourceStream != null) {
                    Files.copy(resourceStream, destination.toPath(), new CopyOption[0]);
                } else {
                    destination.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static YamlConfiguration loadValuesFIle() {
        return YamlConfiguration.loadConfiguration((File)VALUES_FILE);
    }

    public static YamlConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
    }
}

