/*
 * Decompiled with CFR 0.152.
 */
package me.darksoul.WITxMinetorio;

import com.MT.xxxtrigger50xxx.API.MTAPI;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.github.darksoulq.wit.Information;
import com.github.darksoulq.wit.api.API;
import com.github.darksoulq.wit.api.Info;
import com.github.darksoulq.wit.misc.Events;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import me.darksoul.WITxMinetorio.Informations;
import me.darksoul.WITxMinetorio.WITMinetorio;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MinetorioHandler {
    private static final Set<Function<Block, Component>> prefixBlock = new HashSet<Function<Block, Component>>();
    private static final Set<Function<Block, Component>> suffixBlock = new HashSet<Function<Block, Component>>();
    private static final Set<Function<Entity, Component>> suffixEntity = new HashSet<Function<Entity, Component>>();

    public static void setup() {
        prefixBlock.clear();
        suffixBlock.clear();
        if (WITMinetorio.CONFIG.getBoolean("minetorio.containerinfo", true)) {
            prefixBlock.add(Informations::containerInfo);
        }
        if (WITMinetorio.CONFIG.getBoolean("gridconnection", true)) {
            prefixBlock.add(Informations::pylonGridConnections);
        }
        if (WITMinetorio.CONFIG.getBoolean("liquidstored", true)) {
            prefixBlock.add(Informations::getLiquidAmount);
        }
        if (WITMinetorio.CONFIG.getBoolean("powerinfo", true)) {
            suffixBlock.add(Informations::getPower);
        }
        if (WITMinetorio.CONFIG.getBoolean("researchlabprogress", true) && MineMain.techScale != 0.0 && MineMain.useTechnology) {
            suffixBlock.add(Informations::researchLabProgress);
        }
        if (WITMinetorio.CONFIG.getBoolean("smeltinfo", true)) {
            suffixBlock.add(Information::default_getRemainingSmeltTime);
        }
        if (WITMinetorio.CONFIG.getBoolean("biterhealth", true)) {
            suffixEntity.add(Information::default_getEntityHealth);
        }
    }

    public static boolean handleBlock(Block block, Player player) {
        Info info = new Info();
        Device device = MTAPI.getDevice((Location)block.getLocation());
        Mover mover = Mover.getMover((Location)block.getLocation());
        float progress = 0.0f;
        if (WITMinetorio.CONFIG.getBoolean("block-progress") && Events.BREAK_PROGRESS.containsKey(block)) {
            progress = ((Float)Events.BREAK_PROGRESS.get(block)).floatValue();
        }
        if (device != null || mover != null) {
            String deviceName = mover != null ? "Mover" : device.getName();
            for (Function<Block, Component> func : suffixBlock) {
                info.addSuffix(func.apply(block));
            }
            for (Function<Block, Component> func : prefixBlock) {
                info.addPrefix(func.apply(block));
            }
            if (WITMinetorio.CONFIG.getBoolean("toolinfo", true)) {
                info.addPrefix(Information.default_getToolToBreak((Block)block, (Player)player));
            }
            info.setName((Component)Component.text((String)deviceName));
            API.updateBar((Info)info, (float)(1.0f - progress), (Player)player);
            return true;
        }
        return false;
    }

    public static boolean handleEntity(Entity entity, Player player) {
        if (MTAPI.isBiter((Entity)entity)) {
            Info info = new Info();
            info.setName((Component)Component.text((String)"Biter"));
            float health = 0.0f;
            if (WITMinetorio.CONFIG.getBoolean("biter-health-progress") && entity instanceof LivingEntity) {
                health = (float)Math.max(0.0, Math.min(1.0, ((LivingEntity)entity).getHealth() / ((LivingEntity)entity).getAttribute(Attribute.MAX_HEALTH).getValue()));
            }
            for (Function<Entity, Component> func : suffixEntity) {
                info.addSuffix(func.apply(entity));
            }
            API.updateBar((Info)info, (float)(1.0f - health), (Player)player);
        }
        return false;
    }
}

