/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.dynamicrp;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.cjdev.dynamicrp.DynamicRPVelocity;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class RequestHandler
implements HttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(HttpExchange exchange) {
        try {
            if ("GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                String host_name;
                URI requestURI = exchange.getRequestURI();
                Map<String, String> queryParams = DynamicRPVelocity.mapGETQuery(requestURI.getQuery());
                String server = queryParams.get("server");
                if (server != null && (host_name = DynamicRPVelocity.HOST_NAMES.get(server)) != null) {
                    String uuid = queryParams.get("uuid");
                    URL url = new URL("http://" + host_name + "/" + (String)(uuid == null ? "" : "?uuid=" + uuid));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    exchange.getRequestHeaders().forEach((key, values) -> {
                        for (String value : values) {
                            conn.addRequestProperty((String)key, value);
                        }
                    });
                    conn.setDoInput(true);
                    int responseCode = conn.getResponseCode();
                    exchange.sendResponseHeaders(responseCode, conn.getContentLength());
                    try (InputStream is = conn.getInputStream();
                         OutputStream os = exchange.getResponseBody();){
                        is.transferTo(os);
                    }
                    conn.disconnect();
                    return;
                }
                String response = "File not found!";
                byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.sendResponseHeaders(404, responseBytes.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(responseBytes);
                }
                return;
            }
            String msg = "405 Method Not Allowed\n";
            exchange.getResponseHeaders().add("Allow", "GET");
            exchange.sendResponseHeaders(405, msg.length());
            exchange.getResponseBody().write(msg.getBytes());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                String msg = "Proxy error: " + e.getMessage();
                exchange.sendResponseHeaders(500, msg.length());
                exchange.getResponseBody().write(msg.getBytes());
                return;
            }
            catch (Exception exception) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                exchange.close();
            }
            catch (Exception exception) {}
        }
    }
}

