/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.adrien5902.beaconwaypoints.commands.warp;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import net.ddns.adrien5902.beaconwaypoints.Waypoint;
import net.ddns.adrien5902.beaconwaypoints.WaypointConstructor;
import net.ddns.adrien5902.beaconwaypoints.WaypointsManager;
import net.ddns.adrien5902.beaconwaypoints.WaypointsManagerWithWorld;
import net.ddns.adrien5902.beaconwaypoints.commands.warp.WarpCommandGui;
import net.ddns.adrien5902.beaconwaypoints.commands.warp.WaypointSuggestionProvider;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class WarpCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder warpRoot = (LiteralArgumentBuilder)class_2170.method_9247((String)"warp").executes(context -> {
                try {
                    class_2168 src = (class_2168)context.getSource();
                    ArrayList<WaypointsManagerWithWorld> managers = WaypointsManagerWithWorld.readGlobal(src.method_9211());
                    WarpCommandGui gui = new WarpCommandGui(src, managers);
                    gui.open();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                return 1;
            });
            warpRoot.then(class_2170.method_9244((String)"waypoint", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WaypointSuggestionProvider()).executes(context -> {
                class_2168 src = (class_2168)context.getSource();
                String waypoint_name_raw = StringArgumentType.getString((CommandContext)context, (String)"waypoint");
                String waypoint_name = WarpCommand.stripQuotes(waypoint_name_raw);
                ArrayList<WaypointsManagerWithWorld> withWorlds = WaypointsManagerWithWorld.readGlobal(src.method_9211());
                Waypoint found_waypoint = null;
                class_3218 current_world = null;
                WaypointsManager found_manager = null;
                block0: for (WaypointsManagerWithWorld withWorld : withWorlds) {
                    for (Waypoint waypoint : withWorld.manager.waypoints) {
                        current_world = withWorld.world;
                        if (!WarpCommand.equalsIgnoreCase(waypoint_name, waypoint.name)) continue;
                        found_waypoint = waypoint;
                        found_manager = withWorld.manager;
                        break block0;
                    }
                }
                if (found_waypoint == null) {
                    src.method_9213((class_2561)class_2561.method_43471((String)"beaconwaypoints.error.waypoint_not_found"));
                    return 0;
                }
                WarpCommand.teleportTo(src, current_world, found_waypoint, found_manager);
                return 1;
            }));
            LiteralArgumentBuilder removeRoot = (LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"waypoint", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WaypointSuggestionProvider()).executes(context -> {
                class_2168 src = (class_2168)context.getSource();
                String waypoint_name_raw = StringArgumentType.getString((CommandContext)context, (String)"waypoint");
                String waypoint_name = WarpCommand.stripQuotes(waypoint_name_raw);
                ArrayList<WaypointsManagerWithWorld> withWorlds = WaypointsManagerWithWorld.readGlobal(src.method_9211());
                Waypoint found_waypoint = null;
                WaypointsManager found_manager = null;
                class_3218 current_world = null;
                block0: for (WaypointsManagerWithWorld withWorld : withWorlds) {
                    for (Waypoint waypoint : withWorld.manager.waypoints) {
                        current_world = withWorld.world;
                        if (!WarpCommand.equalsIgnoreCase(waypoint_name, waypoint.name)) continue;
                        found_waypoint = waypoint;
                        found_manager = withWorld.manager;
                        break block0;
                    }
                }
                if (found_waypoint == null) {
                    src.method_9213((class_2561)class_2561.method_43471((String)"beaconwaypoints.error.waypoint_removal_failed"));
                    return 0;
                }
                class_243 beaconCenter = found_waypoint.pos.method_46558();
                String removedName = found_waypoint.name;
                class_2338 targetPos = found_waypoint.pos;
                boolean removed = found_manager.waypoints.removeIf(w -> w.pos.equals((Object)targetPos));
                if (removed) {
                    found_manager.method_80();
                    src.method_9226(() -> class_2561.method_43469((String)"beaconwaypoints.success.waypoint_removed", (Object[])new Object[]{removedName}), false);
                    if (current_world != null) {
                        current_world.method_43128(null, beaconCenter.field_1352, beaconCenter.field_1351, beaconCenter.field_1350, class_3417.field_19344, class_3419.field_15248, 1.0f, 1.0f);
                    }
                    return 1;
                }
                src.method_9213((class_2561)class_2561.method_43471((String)"beaconwaypoints.error.waypoint_removal_failed"));
                return 0;
            }));
            warpRoot.then((ArgumentBuilder)removeRoot);
            dispatcher.register(warpRoot);
        });
    }

    private static boolean equalsIgnoreCase(String a, String b) {
        return a.toLowerCase(Locale.ROOT).equals(b.toLowerCase(Locale.ROOT));
    }

    private static String stripQuotes(String s) {
        if (s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static void teleportTo(class_2168 src, class_3218 world, Waypoint waypoint, WaypointsManager manager) {
        if (!WaypointConstructor.isValidWaypoint((class_1937)world, waypoint.pos)) {
            if (manager != null) {
                manager.waypoints.removeIf(w -> w.pos.equals((Object)waypoint.pos));
                manager.method_80();
            }
            src.method_9213((class_2561)class_2561.method_43469((String)"beaconwaypoints.error.waypoint_teleport_invalid", (Object[])new Object[]{waypoint.name}));
            return;
        }
        class_243 pos = waypoint.pos.method_46558();
        src.method_44023().method_48105(world, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, Set.of(), 0.0f, 0.0f, false);
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_46945, class_3419.field_15248, 1.0f, 1.0f);
        world.method_65096((class_2394)class_2398.field_11249, pos.field_1352, pos.field_1351, pos.field_1350, 50, 0.0, 0.5, 0.0, 2.0);
        src.method_9226(() -> class_2561.method_43469((String)"beaconwaypoints.success.teleporting_to", (Object[])new Object[]{waypoint.name}), false);
    }
}

