/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.adrien5902.beaconwaypoints.commands.warp;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ddns.adrien5902.beaconwaypoints.Waypoint;
import net.ddns.adrien5902.beaconwaypoints.WaypointsManagerWithWorld;
import net.ddns.adrien5902.beaconwaypoints.commands.warp.WarpCommand;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class WarpCommandGui {
    private class_2168 src;
    private SimpleGui gui;
    private int page = 0;
    private List<class_3545<Waypoint, class_3218>> waypoints;
    private int max_page;
    private static final int PAGE_SIZE = 18;
    private static final int LEFT_BOTTOM = 18;
    private static final int MIDDLE_BOTTOM = 22;
    private static final int RIGHT_BOTTOM = 26;

    public WarpCommandGui(class_2168 src, ArrayList<WaypointsManagerWithWorld> withWorlds) {
        this.src = src;
        this.gui = new SimpleGui(class_3917.field_17326, src.method_44023(), false);
        this.gui.setTitle((class_2561)class_2561.method_43470((String)"Beacon Waypoints"));
        this.gui.setAutoUpdate(true);
        this.waypoints = withWorlds.stream().flatMap(withWorld -> withWorld.manager.waypoints.stream().map(waypoint -> new class_3545(waypoint, (Object)withWorld.world))).toList();
        this.max_page = Math.floorDiv(this.waypoints.size() == 0 ? 0 : this.waypoints.size() - 1, 18);
    }

    public void open() {
        this.gui.open();
        this.refresh();
    }

    private void refresh() {
        for (int i = 0; i < 18; ++i) {
            this.gui.clearSlot(i);
        }
        List<GuiElement> uiElements = this.getPageUiElements(this.page);
        for (int i = 0; i < uiElements.size(); ++i) {
            this.gui.setSlot(i, (GuiElementInterface)uiElements.get(i));
        }
        if (this.page > 0) {
            this.gui.setSlot(18, (GuiElementInterface)new GuiElementBuilder().setItem(class_1802.field_8107).setName((class_2561)class_2561.method_43469((String)"beaconwaypoints.gui.go_to_page", (Object[])new Object[]{this.page})).setCount(this.page).setCallback((index, type, action) -> {
                if (this.page > 0) {
                    --this.page;
                    this.refresh();
                }
            }).build());
        } else {
            this.gui.clearSlot(18);
        }
        if (this.page < this.max_page) {
            this.gui.setSlot(26, (GuiElementInterface)new GuiElementBuilder().setItem(class_1802.field_8107).setName((class_2561)class_2561.method_43469((String)"beaconwaypoints.gui.go_to_page", (Object[])new Object[]{this.page + 2})).setCount(this.page + 2).setCallback((index, type, action) -> {
                if (this.page < this.max_page) {
                    ++this.page;
                }
                this.refresh();
            }).build());
        } else {
            this.gui.clearSlot(26);
        }
        this.gui.setSlot(22, (GuiElementInterface)new GuiElementBuilder().setItem(class_1802.field_8407).setName((class_2561)class_2561.method_43469((String)"beaconwaypoints.gui.on_page", (Object[])new Object[]{this.page + 1})).setCount(this.page + 1).build());
    }

    private List<GuiElement> getPageUiElements(int page) {
        return this.getPage(page).stream().map(pair -> {
            class_1799 stack = ((Waypoint)pair.method_15442()).getGuiItemStack();
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)((Waypoint)pair.method_15442()).name).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
            class_9290 lore = new class_9290(Arrays.asList(((Waypoint)pair.method_15442()).getTooltip((class_1937)pair.method_15441())));
            stack.method_57379(class_9334.field_49632, (Object)lore);
            return new GuiElement(stack, (index, type, action) -> {
                WaypointsManagerWithWorld.fromWorld((class_3218)((class_3218)pair.method_15441())).manager.method_80();
                WarpCommand.teleportTo(this.src, (class_3218)pair.method_15441(), (Waypoint)pair.method_15442(), WaypointsManagerWithWorld.fromWorld((class_3218)((class_3218)pair.method_15441())).manager);
                this.gui.close();
            });
        }).toList();
    }

    private List<class_3545<Waypoint, class_3218>> getPage(int page) {
        int max_index = this.waypoints.size() < (page + 1) * 18 ? this.waypoints.size() : (page + 1) * 18;
        return this.waypoints.subList(page * 18, max_index);
    }
}

