/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CoreModInjector
implements ITransformer<ClassNode> {
    public static final Logger logger = LogManager.getLogger((String)"matmos_tct_injector");

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/client/audio/SoundEngine"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/client/audio/AudioStreamManager"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/client/audio/SoundSource"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/client/audio/Sound"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/client/audio/SoundSystem"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/server/management/PlayerList"));
        targets.add(ITransformer.Target.targetClass((String)"net/minecraft/entity/Entity"));
        return targets;
    }

    public ClassNode transform(ClassNode classNode, ITransformerVotingContext context) {
        String className = classNode.name;
        CoreModInjector.log("Wants to transform: '" + className + "'");
        if (className.equals("net/minecraft/client/audio/SoundEngine")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "init", "(Lnet/minecraft/client/audio/SoundEngine;)V", false));
            classNode = this.patchMethodInClass(classNode, "func_148608_i", "()V", 185, 5, "info", null, -1, toInject, false, 0, 0, false, 0, -1);
            toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "applyGlobalVolumeMultiplier", "(FLnet/minecraft/client/audio/ISound;)F", false));
            classNode = this.patchMethodInClass(classNode, "func_188770_e", "(Lnet/minecraft/client/audio/ISound;)F", 174, 0, null, null, -1, toInject, true, 0, 0, false, 0, -1);
            toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "onPlaySound", "(Lnet/minecraft/client/audio/ISound;Lnet/minecraft/client/audio/SoundSource;)V", false));
            classNode = this.patchMethodInClass(classNode, "lambda$null$5", "(Lnet/minecraft/client/audio/AudioStreamBuffer;Lnet/minecraft/client/audio/ISound;Lnet/minecraft/client/audio/SoundSource;)V", 182, 5, "func_216438_c", null, -1, toInject, true, 0, 0, false, 0, -1);
        } else if (className.equals("net/minecraft/client/audio/SoundSystem")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "createALContext", "(JLorg/lwjgl/openal/ALCCapabilities;)J", false));
            classNode = this.patchMethodInClass(classNode, "func_216404_a", "()V", 184, 5, "alcCreateContext", null, -1, toInject, true, 2, 0, true, 0, -1);
        } else if (className.equals("net/minecraft/client/audio/AudioStreamManager")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "onLoadSound", "(Lnet/minecraft/client/audio/AudioStreamBuffer;Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/audio/AudioStreamBuffer;", false));
            classNode = this.patchMethodInClass(classNode, "func_217914_e", "(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/audio/AudioStreamBuffer;", 183, 5, "<init>", "(Ljava/nio/ByteBuffer;Ljavax/sound/sampled/AudioFormat;)V", -1, toInject, false, 0, 0, false, 0, -1);
        } else if (className.equals("net/minecraft/server/management/PlayerList")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "soundDistanceAllowance", "D"));
            toInject.add((AbstractInsnNode)new InsnNode(107));
            classNode = this.patchMethodInClass(classNode, "func_148543_a", "(Lnet/minecraft/entity/player/PlayerEntity;DDDDLnet/minecraft/world/dimension/DimensionType;Lnet/minecraft/network/IPacket;)V", 152, 0, null, null, -1, toInject, true, 0, 0, false, 0, -1);
        } else if (className.equals("net/minecraft/client/audio/Sound")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "soundDistanceAllowance", "D"));
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "soundDistanceAllowance", "D"));
            toInject.add((AbstractInsnNode)new InsnNode(107));
            toInject.add((AbstractInsnNode)new InsnNode(142));
            toInject.add((AbstractInsnNode)new InsnNode(104));
            classNode = this.patchMethodInClass(classNode, "func_206255_j", "()I", 180, 4, null, null, -1, toInject, false, 0, 0, false, 0, -1);
        } else if (className.equals("net/minecraft/entity/Entity")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/sonicether/soundphysics/SoundPhysics", "calculateEntitySoundOffset", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/SoundEvent;)D", false));
            toInject.add((AbstractInsnNode)new InsnNode(99));
            classNode = this.patchMethodInClass(classNode, "func_184185_a", "(Lnet/minecraft/util/SoundEvent;FF)V", 182, 5, "func_226278_cu_", null, -1, toInject, false, 0, 0, false, 0, -1);
        } else if (className.equals("net/minecraft/client/audio/SoundSource")) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "attenuationModel", "I"));
            classNode = this.patchMethodInClass(classNode, "func_216423_c", "(F)V", 184, 5, "alSourcei", null, -1, toInject, true, 1, 0, false, 0, -1);
            toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "globalRolloffFactor", "F"));
            classNode = this.patchMethodInClass(classNode, "func_216423_c", "(F)V", 184, 5, "alSourcef", null, -1, toInject, true, 1, 0, false, 0, 1);
            toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/sonicether/soundphysics/SoundPhysics", "referenceDistance", "F"));
            classNode = this.patchMethodInClass(classNode, "func_216423_c", "(F)V", 184, 5, "alSourcef", null, -1, toInject, true, 1, 0, false, 0, 2);
        }
        return classNode;
    }

    private ClassNode patchMethodInClass(ClassNode classNode, String targetMethod, String targetMethodSignature, int targetNodeOpcode, int targetNodeType, String targetInvocationMethodName, String targetInvocationMethodSignature, int targetVarNodeIndex, InsnList instructionsToInject, boolean insertBefore, int nodesToDeleteBefore, int nodesToDeleteAfter, boolean deleteTargetNode, int targetNodeOffset, int targetNodeNumber) {
        String className = classNode.name;
        CoreModInjector.log("Patching class : " + className);
        for (MethodNode m : classNode.methods) {
            int i;
            if (!m.name.equals(targetMethod) || !m.desc.equals(targetMethodSignature)) continue;
            CoreModInjector.log("Inside target method: " + targetMethod);
            AbstractInsnNode targetNode = null;
            int targetNodeNb = 0;
            for (AbstractInsnNode currentNode : m.instructions) {
                if (currentNode.getOpcode() != targetNodeOpcode) continue;
                if (targetNodeType == 5) {
                    if (currentNode.getType() != 5) continue;
                    MethodInsnNode method = (MethodInsnNode)currentNode;
                    if (!method.name.equals(targetInvocationMethodName) || !method.desc.equals(targetInvocationMethodSignature) && targetInvocationMethodSignature != null) continue;
                    CoreModInjector.log("Found target method invocation for injection: " + targetInvocationMethodName);
                    targetNode = currentNode;
                    if (targetNodeNumber >= 0 && targetNodeNb == targetNodeNumber) break;
                    ++targetNodeNb;
                    continue;
                }
                if (targetNodeType == 2) {
                    if (currentNode.getType() != 2) continue;
                    VarInsnNode varnode = (VarInsnNode)currentNode;
                    if (targetVarNodeIndex >= 0 && varnode.var != targetVarNodeIndex) continue;
                    CoreModInjector.log("Found target var node for injection: " + targetVarNodeIndex);
                    targetNode = currentNode;
                    if (targetNodeNumber >= 0 && targetNodeNb == targetNodeNumber) break;
                    ++targetNodeNb;
                    continue;
                }
                if (currentNode.getType() != targetNodeType) continue;
                CoreModInjector.log("Found target node for injection: " + targetNodeType);
                targetNode = currentNode;
                if (targetNodeNumber >= 0 && targetNodeNb == targetNodeNumber) break;
                ++targetNodeNb;
            }
            if (targetNode == null) {
                CoreModInjector.logError("Target node not found! " + className);
                break;
            }
            if (targetNodeOffset > 0) {
                for (int i2 = 0; i2 < targetNodeOffset; ++i2) {
                    targetNode = targetNode.getNext();
                }
            } else if (targetNodeOffset < 0) {
                for (int i3 = 0; i3 < -targetNodeOffset; ++i3) {
                    targetNode = targetNode.getPrevious();
                }
            }
            for (i = 0; i < nodesToDeleteBefore; ++i) {
                AbstractInsnNode previousNode = targetNode.getPrevious();
                CoreModInjector.log("Removing Node " + previousNode.getOpcode());
                m.instructions.remove(previousNode);
            }
            for (i = 0; i < nodesToDeleteAfter; ++i) {
                AbstractInsnNode nextNode = targetNode.getNext();
                CoreModInjector.log("Removing Node " + nextNode.getOpcode());
                m.instructions.remove(nextNode);
            }
            if (insertBefore) {
                m.instructions.insertBefore(targetNode, instructionsToInject);
            } else {
                m.instructions.insert(targetNode, instructionsToInject);
            }
            if (!deleteTargetNode) break;
            m.instructions.remove(targetNode);
            break;
        }
        CoreModInjector.log("Class finished : " + className);
        return classNode;
    }

    public static void log(String message) {
        logger.debug(message);
    }

    public static void logError(String errorMessage) {
        logger.error(errorMessage);
    }
}

