/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.CoreModInjector;
import com.sonicether.soundphysics.SoundPhysics;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;

public class CoreModTransformationService
implements ITransformationService {
    public static Path mcPath;

    public String name() {
        return "matmos_tct_transformer";
    }

    public void initialize(IEnvironment environment) {
        try {
            Field field = ModDirTransformerDiscoverer.class.getDeclaredField("transformers");
            field.setAccessible(true);
            List transformers = (List)field.get(null);
            Path jarFile = Paths.get(SoundPhysics.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            boolean removed = transformers.remove(jarFile);
            if (removed) {
                return;
            }
            removed = transformers.remove(jarFile.toRealPath(new LinkOption[0]));
            if (removed) {
                return;
            }
            ListIterator iter = transformers.listIterator();
            while (iter.hasNext()) {
                if (!Files.isSameFile((Path)iter.next(), jarFile)) continue;
                iter.remove();
                removed = true;
            }
            if (!removed) {
                CoreModInjector.logError("Couldn't remove Sound Physics from transformers");
            }
        }
        catch (Throwable e) {
            CoreModInjector.logError("Failed to remove Sound Physics from the transformers");
            CoreModInjector.logError(e.toString());
        }
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        Optional path = env.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get());
        if (path.isPresent()) {
            mcPath = (Path)path.get();
        }
    }

    public List<ITransformer> transformers() {
        return Collections.singletonList(new CoreModInjector());
    }
}

