/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.Config;
import com.sonicether.soundphysics.ReverbParams;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFormat;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.ElytraSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.EXTEfx;

@Mod(value="matmos_tct")
public class SoundPhysics {
    public static final String modid = "matmos_tct";
    public static final Logger logger = LogManager.getLogger((String)"matmos_tct");
    private static final Pattern rainPattern = Pattern.compile(".*rain.*");
    private static final Pattern stepPattern = Pattern.compile(".*step.*");
    private static final Pattern blockPattern = Pattern.compile(".*block.*");
    private static final Pattern uiPattern = Pattern.compile(".*\\/ui\\/.*");
    private static final Pattern clickPattern = Pattern.compile(".*random.click.*");
    private static final Pattern noteBlockPattern = Pattern.compile(".*block.note.*");
    private static final Pattern betweenlandsPattern = Pattern.compile("thebetweenlands:sounds\\/rift_.*\\.ogg");
    private static final Pattern travelPattern = Pattern.compile(".*portal\\/travel*.*");
    private static final Pattern elytraPattern = Pattern.compile(".*elytra\\/elytra_loop*.*");
    private static final Pattern ambientUnderwaterPattern = Pattern.compile(".*ambient\\/underwater\\/additions\\/*.*");
    private static int auxFXSlot0;
    private static int auxFXSlot1;
    private static int auxFXSlot2;
    private static int auxFXSlot3;
    private static int reverb0;
    private static int reverb1;
    private static int reverb2;
    private static int reverb3;
    private static int directFilter0;
    private static int sendFilter0;
    private static int sendFilter1;
    private static int sendFilter2;
    private static int sendFilter3;
    private static Minecraft mc;
    private static SoundEngine sndEngine;
    public static int attenuationModel;
    public static float referenceDistance;
    public static float globalRolloffFactor;
    public static float globalVolumeMultiplier0;
    public static float globalReverbMultiplier;
    public static double soundDistanceAllowance;

    public SoundPhysics() {
        SoundPhysics.log("Mod Constructor");
        MinecraftForge.EVENT_BUS.register(SoundPhysics.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG_SPEC);
    }

    public static void init(SoundEngine engine) {
        SoundPhysics.log("Sound Physics Init");
        mc = Minecraft.func_71410_x();
        sndEngine = engine;
        try {
            SoundPhysics.setupEFX();
        }
        catch (Throwable e) {
            SoundPhysics.logError("Failed to init EFX");
            SoundPhysics.logError(e.toString());
        }
    }

    public static void applyConfigChanges() {
        referenceDistance = Config.referenceDistance;
        globalRolloffFactor = Config.rolloffFactor;
        globalReverbMultiplier = 0.7f * Config.globalReverbGain;
        soundDistanceAllowance = Config.soundDistanceAllowance;
        globalVolumeMultiplier0 = Config.globalVolumeMultiplier;
        if (auxFXSlot0 != 0) {
            SoundPhysics.setReverbParams(ReverbParams.getReverb0(), auxFXSlot0, reverb0);
            SoundPhysics.setReverbParams(ReverbParams.getReverb1(), auxFXSlot1, reverb1);
            SoundPhysics.setReverbParams(ReverbParams.getReverb2(), auxFXSlot2, reverb2);
            SoundPhysics.setReverbParams(ReverbParams.getReverb3(), auxFXSlot3, reverb3);
        }
    }

    public static long createALContext(long device, ALCCapabilities caps) {
        int[] attribs = null;
        if (caps.ALC_EXT_EFX) {
            attribs = new int[]{131075, 8, 0};
        }
        return ALC10.alcCreateContext((long)device, attribs);
    }

    private static void setupEFX() {
        long currentContext = ALC10.alcGetCurrentContext();
        long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
        if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
            SoundPhysics.logError("EFX Extension not found on current device. Aborting.");
            return;
        }
        SoundPhysics.log("EFX Extension recognized.");
        int nbSends = ALC10.alcGetInteger((long)currentDevice, (int)131075);
        if (nbSends < 4) {
            SoundPhysics.logError("Not enough Aux Sends (" + String.valueOf(nbSends) + "). Aborting");
            return;
        }
        SoundPhysics.log(String.valueOf(nbSends) + " of aux sends");
        auxFXSlot0 = EXTEfx.alGenAuxiliaryEffectSlots();
        SoundPhysics.log("Aux slot " + auxFXSlot0 + " created");
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot0, (int)3, (int)1);
        auxFXSlot1 = EXTEfx.alGenAuxiliaryEffectSlots();
        SoundPhysics.log("Aux slot " + auxFXSlot1 + " created");
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot1, (int)3, (int)1);
        auxFXSlot2 = EXTEfx.alGenAuxiliaryEffectSlots();
        SoundPhysics.log("Aux slot " + auxFXSlot2 + " created");
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot2, (int)3, (int)1);
        auxFXSlot3 = EXTEfx.alGenAuxiliaryEffectSlots();
        SoundPhysics.log("Aux slot " + auxFXSlot3 + " created");
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot3, (int)3, (int)1);
        SoundPhysics.checkErrorLog("Failed creating auxiliary effect slots!");
        reverb0 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb0, (int)32769, (int)32768);
        SoundPhysics.checkErrorLog("Failed creating reverb effect slot 0!");
        reverb1 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb1, (int)32769, (int)32768);
        SoundPhysics.checkErrorLog("Failed creating reverb effect slot 1!");
        reverb2 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb2, (int)32769, (int)32768);
        SoundPhysics.checkErrorLog("Failed creating reverb effect slot 2!");
        reverb3 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb3, (int)32769, (int)32768);
        SoundPhysics.checkErrorLog("Failed creating reverb effect slot 3!");
        directFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)directFilter0, (int)32769, (int)1);
        sendFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter0, (int)32769, (int)1);
        sendFilter1 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter1, (int)32769, (int)1);
        sendFilter2 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter2, (int)32769, (int)1);
        sendFilter3 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter3, (int)32769, (int)1);
        SoundPhysics.checkErrorLog("Error creating lowpass filters!");
        SoundPhysics.applyConfigChanges();
    }

    public static String getSoundName(ISound sound) {
        Sound s = sound.func_184364_b();
        if (s == null || s == SoundHandler.field_147700_a) {
            return sound.func_147650_b().func_110623_a();
        }
        return sound.func_147650_b().func_110623_a() + "|" + s.func_188719_a().func_110623_a();
    }

    public static SoundCategory getSoundCategory(ISound sound) {
        return SoundPhysics.getSoundCategory(sound, SoundPhysics.getSoundName(sound));
    }

    public static SoundCategory getSoundCategory(ISound sound, String soundName) {
        SoundCategory sc = sound.func_184365_d();
        if (Config.noteBlockEnable && sc == SoundCategory.RECORDS && noteBlockPattern.matcher(soundName).matches()) {
            return SoundCategory.BLOCKS;
        }
        return sc;
    }

    public static float applyGlobalVolumeMultiplier(float volume, ISound sound) {
        SoundCategory cat = SoundPhysics.getSoundCategory(sound);
        if (!Config.volumeMulOnlyAffected || SoundPhysics.mc.field_71439_g != null && SoundPhysics.mc.field_71441_e != null && sound.func_147656_j() != ISound.AttenuationType.NONE && !sound.func_217861_m() && cat != SoundCategory.RECORDS && cat != SoundCategory.MUSIC && cat != SoundCategory.RECORDS) {
            return volume * globalVolumeMultiplier0;
        }
        return volume;
    }

    public static void onPlaySound(ISound snd, SoundSource sndsrc) {
        if (snd.func_217861_m() || snd instanceof ElytraSound) {
            return;
        }
        String name = SoundPhysics.getSoundName(snd);
        SoundPhysics.onPlaySound(snd.func_147649_g(), snd.func_147654_h(), snd.func_147651_i(), sndsrc.field_216441_b, SoundPhysics.getSoundCategory(snd, name), name, snd.func_147656_j());
    }

    public static void onPlaySound(float posX, float posY, float posZ, int sourceID, SoundCategory soundCat, String soundName, ISound.AttenuationType attType) {
        SoundPhysics.evaluateEnvironment(sourceID, posX, posY, posZ, soundCat, soundName, attType);
    }

    public static AudioStreamBuffer onLoadSound(AudioStreamBuffer buff, ResourceLocation resource) {
        if (buff == null || buff.field_216476_b.getChannels() == 1 || !Config.autoSteroDownmix) {
            return buff;
        }
        String filename = resource.func_110623_a();
        if (mc == null || SoundPhysics.mc.field_71439_g == null || SoundPhysics.mc.field_71441_e == null || uiPattern.matcher(filename).matches() || clickPattern.matcher(filename).matches() || betweenlandsPattern.matcher(filename).matches() || travelPattern.matcher(filename).matches() || elytraPattern.matcher(filename).matches() || ambientUnderwaterPattern.matcher(filename).matches()) {
            if (Config.autoSteroDownmixLogging) {
                SoundPhysics.log("Not converting sound '" + filename + "'(" + buff.field_216476_b.toString() + ")");
            }
            return buff;
        }
        AudioFormat orignalformat = buff.field_216476_b;
        int bits = orignalformat.getSampleSizeInBits();
        boolean bigendian = orignalformat.isBigEndian();
        AudioFormat monoformat = new AudioFormat(orignalformat.getEncoding(), orignalformat.getSampleRate(), bits, 1, orignalformat.getFrameSize(), orignalformat.getFrameRate(), bigendian);
        if (Config.autoSteroDownmixLogging) {
            SoundPhysics.log("Converting sound '" + filename + "'(" + orignalformat.toString() + ") to mono (" + monoformat.toString() + ")");
        }
        ByteBuffer src = buff.field_216475_a;
        src.order(bigendian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        src.rewind();
        int size = src.remaining();
        if (bits == 8) {
            for (int i = 0; i < size; i += 2) {
                src.put(i / 2, (byte)((src.get(i) + src.get(i + 1)) / 2));
            }
        } else if (bits == 16) {
            for (int i = 0; i < size; i += 4) {
                src.putShort(i / 2, (short)((src.getShort(i) + src.getShort(i + 2)) / 2));
            }
        }
        src.flip();
        buff.field_216476_b = monoformat;
        return buff;
    }

    public static double calculateEntitySoundOffset(Entity entity, SoundEvent sound) {
        if (sound == null) {
            return entity.func_70047_e();
        }
        if (stepPattern.matcher(sound.func_187503_a().func_110623_a()).matches()) {
            return 0.0;
        }
        return entity.func_70047_e();
    }

    public static boolean isSnowingAt(BlockPos position, boolean check_rain) {
        if (check_rain && !SoundPhysics.mc.field_71441_e.func_72896_J()) {
            return false;
        }
        if (!SoundPhysics.mc.field_71441_e.func_226660_f_(position)) {
            return false;
        }
        if (SoundPhysics.mc.field_71441_e.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        return SoundPhysics.mc.field_71441_e.func_226691_t_(position).func_201851_b() == Biome.RainType.SNOW;
    }

    private static float getBlockReflectivity(BlockPos blockPos) {
        Block block = SoundPhysics.mc.field_71441_e.func_180495_p(blockPos).func_177230_c();
        SoundType soundType = block.func_220072_p(null);
        float reflectivity = 0.5f;
        if (soundType == SoundType.field_185851_d) {
            reflectivity = Config.stoneReflectivity;
        } else if (soundType == SoundType.field_185848_a || soundType == SoundType.field_222470_q) {
            reflectivity = Config.woodReflectivity;
        } else if (soundType == SoundType.field_185849_b) {
            reflectivity = Config.groundReflectivity;
        } else if (soundType == SoundType.field_185850_c || soundType == SoundType.field_211382_m || soundType == SoundType.field_211383_n || soundType == SoundType.field_222468_o || soundType == SoundType.field_222469_p || soundType == SoundType.field_222472_s || soundType == SoundType.field_222473_t || soundType == SoundType.field_222474_u || soundType == SoundType.field_222471_r) {
            reflectivity = Config.plantReflectivity;
        } else if (soundType == SoundType.field_185852_e || soundType == SoundType.field_222475_v) {
            reflectivity = Config.metalReflectivity;
        } else if (soundType == SoundType.field_185853_f) {
            reflectivity = Config.glassReflectivity;
        } else if (soundType == SoundType.field_185854_g) {
            reflectivity = Config.clothReflectivity;
        } else if (soundType == SoundType.field_185855_h) {
            reflectivity = Config.sandReflectivity;
        } else if (soundType == SoundType.field_185856_i) {
            reflectivity = Config.snowReflectivity;
        } else if (soundType == SoundType.field_185857_j) {
            reflectivity = Config.woodReflectivity;
        } else if (soundType == SoundType.field_185858_k) {
            reflectivity = Config.metalReflectivity;
        } else if (soundType == SoundType.field_185859_l || soundType == SoundType.field_226947_m_) {
            reflectivity = Config.slimeReflectivity;
        }
        return reflectivity *= Config.globalBlockReflectance;
    }

    private static Vec3d getNormalFromFacing(Direction sideHit) {
        return new Vec3d(sideHit.func_176730_m());
    }

    private static Vec3d reflect(Vec3d dir, Vec3d normal) {
        double dot2 = dir.func_72430_b(normal) * 2.0;
        double x = dir.field_72450_a - dot2 * normal.field_72450_a;
        double y = dir.field_72448_b - dot2 * normal.field_72448_b;
        double z = dir.field_72449_c - dot2 * normal.field_72449_c;
        return new Vec3d(x, y, z);
    }

    private static Vec3d offsetSoundByName(double soundX, double soundY, double soundZ, Vec3d playerPos, String name, SoundCategory category) {
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        double offsetTowardsPlayer = 0.0;
        double tempNormX = 0.0;
        double tempNormY = 0.0;
        double tempNormZ = 0.0;
        if (soundY % 1.0 < 0.001 || stepPattern.matcher(name).matches()) {
            offsetY = 0.225;
        }
        if ((category == SoundCategory.BLOCKS || blockPattern.matcher(name).matches() || name == "openal" && !SoundPhysics.mc.field_71441_e.func_175623_d(new BlockPos(soundX, soundY, soundZ))) && (MathHelper.func_76128_c((double)playerPos.field_72450_a) != MathHelper.func_76128_c((double)soundX) || MathHelper.func_76128_c((double)playerPos.field_72448_b) != MathHelper.func_76128_c((double)soundY) || MathHelper.func_76128_c((double)playerPos.field_72449_c) != MathHelper.func_76128_c((double)soundZ))) {
            tempNormX = playerPos.field_72450_a - soundX;
            tempNormY = playerPos.field_72448_b - soundY;
            tempNormZ = playerPos.field_72449_c - soundZ;
            double length = Math.sqrt(tempNormX * tempNormX + tempNormY * tempNormY + tempNormZ * tempNormZ);
            offsetTowardsPlayer = 0.867;
            offsetX += (tempNormX /= length) * offsetTowardsPlayer;
            offsetY += (tempNormY /= length) * offsetTowardsPlayer;
            offsetZ += (tempNormZ /= length) * offsetTowardsPlayer;
        }
        return new Vec3d(soundX + offsetX, soundY + offsetY, soundZ + offsetZ);
    }

    private static BlockRayTraceResult rayTraceBlocks(Vec3d start, Vec3d stop, boolean stopOnLiquid) {
        return SoundPhysics.mc.field_71441_e.func_217299_a(new RayTraceContext(start, stop, RayTraceContext.BlockMode.COLLIDER, stopOnLiquid ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)SoundPhysics.mc.field_71439_g));
    }

    private static void evaluateEnvironment(int sourceID, float posX, float posY, float posZ, SoundCategory category, String name, ISound.AttenuationType attType) {
        try {
            BlockRayTraceResult rayHit;
            boolean isRain;
            if (SoundPhysics.mc.field_71439_g == null || SoundPhysics.mc.field_71441_e == null || category == SoundCategory.MASTER || attType == ISound.AttenuationType.NONE || category == SoundCategory.RECORDS || category == SoundCategory.MUSIC) {
                SoundPhysics.setEnvironment(sourceID, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            boolean bl = isRain = category == SoundCategory.WEATHER;
            if (Config.skipRainOcclusionTracing && isRain) {
                SoundPhysics.setEnvironment(sourceID, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            float directCutoff = 1.0f;
            float absorptionCoeff = Config.globalBlockAbsorption * 3.0f;
            Vec3d playerPos = new Vec3d(SoundPhysics.mc.field_71439_g.func_226277_ct_(), SoundPhysics.mc.field_71439_g.func_226278_cu_() + (double)SoundPhysics.mc.field_71439_g.func_70047_e(), SoundPhysics.mc.field_71439_g.func_226281_cx_());
            Vec3d soundPos = SoundPhysics.offsetSoundByName(posX, posY, posZ, playerPos, name, category);
            Vec3d normalToPlayer = playerPos.func_178788_d(soundPos).func_72432_b();
            float airAbsorptionFactor = 1.0f;
            if (Config.snowAirAbsorptionFactor > 1.0f && SoundPhysics.mc.field_71441_e.func_72896_J()) {
                Vec3d middlePos = playerPos.func_178787_e(soundPos).func_186678_a(0.5);
                BlockPos playerPosBlock = new BlockPos(playerPos);
                BlockPos soundPosBlock = new BlockPos(soundPos);
                BlockPos middlePosBlock = new BlockPos(middlePos);
                boolean snowingPlayer = SoundPhysics.isSnowingAt(playerPosBlock, false);
                boolean snowingSound = SoundPhysics.isSnowingAt(soundPosBlock, false);
                boolean snowingMiddle = SoundPhysics.isSnowingAt(middlePosBlock, false);
                float snowFactor = (float)snowingPlayer * 0.25f + (float)snowingMiddle * 0.5f + (float)snowingSound * 0.25f;
                airAbsorptionFactor = Math.max(Config.snowAirAbsorptionFactor * SoundPhysics.mc.field_71441_e.func_72867_j(1.0f) * snowFactor, airAbsorptionFactor);
            }
            Vec3d rayOrigin = soundPos;
            float occlusionAccumulation = 0.0f;
            for (int i = 0; i < 10 && (rayHit = SoundPhysics.rayTraceBlocks(rayOrigin, playerPos, true)).func_216346_c() != RayTraceResult.Type.MISS; ++i) {
                BlockState blockHit = SoundPhysics.mc.field_71441_e.func_180495_p(rayHit.func_216350_a());
                float blockOcclusion = 1.0f;
                if (!blockHit.func_200015_d((IBlockReader)SoundPhysics.mc.field_71441_e, rayHit.func_216350_a())) {
                    blockOcclusion *= 0.15f;
                }
                occlusionAccumulation += blockOcclusion;
                Vec3d hitVec = rayHit.func_216347_e();
                rayOrigin = new Vec3d(hitVec.field_72450_a + normalToPlayer.field_72450_a * 0.1, hitVec.field_72448_b + normalToPlayer.field_72448_b * 0.1, hitVec.field_72449_c + normalToPlayer.field_72449_c * 0.1);
            }
            directCutoff = (float)Math.exp(-occlusionAccumulation * absorptionCoeff);
            float directGain = (float)Math.pow(directCutoff, 0.1);
            float sendGain0 = 0.0f;
            float sendGain1 = 0.0f;
            float sendGain2 = 0.0f;
            float sendGain3 = 0.0f;
            float sendCutoff0 = 1.0f;
            float sendCutoff1 = 1.0f;
            float sendCutoff2 = 1.0f;
            float sendCutoff3 = 1.0f;
            if (SoundPhysics.mc.field_71439_g.func_204231_K()) {
                directCutoff *= 1.0f - Config.underwaterFilter;
            }
            if (isRain) {
                SoundPhysics.setEnvironment(sourceID, sendGain0, sendGain1, sendGain2, sendGain3, sendCutoff0, sendCutoff1, sendCutoff2, sendCutoff3, directCutoff, directGain, airAbsorptionFactor);
                return;
            }
            float phi = 1.618034f;
            float gAngle = 10.166408f;
            float maxDistance = Config.maxDistance;
            int numRays = Config.environmentEvaluationRays;
            int rayBounces = 4;
            float[] bounceReflectivityRatio = new float[4];
            float sharedAirspace = 0.0f;
            float rcpTotalRays = 1.0f / (float)(numRays * 4);
            float rcpPrimaryRays = 1.0f / (float)numRays;
            block3: for (int i = 0; i < numRays; ++i) {
                float fi = i;
                float fiN = fi / (float)numRays;
                float longitude = 10.166408f * fi;
                float latitude = (float)Math.asin(fiN * 2.0f - 1.0f);
                Vec3d rayDir = new Vec3d(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude));
                Vec3d rayStart = new Vec3d(soundPos.field_72450_a, soundPos.field_72448_b, soundPos.field_72449_c);
                Vec3d rayEnd = new Vec3d(rayStart.field_72450_a + rayDir.field_72450_a * (double)maxDistance, rayStart.field_72448_b + rayDir.field_72448_b * (double)maxDistance, rayStart.field_72449_c + rayDir.field_72449_c * (double)maxDistance);
                BlockRayTraceResult rayHit2 = SoundPhysics.rayTraceBlocks(rayStart, rayEnd, true);
                if (rayHit2.func_216346_c() == RayTraceResult.Type.MISS) continue;
                BlockPos lastHitBlock = rayHit2.func_216350_a();
                Vec3d lastHitPos = rayHit2.func_216347_e();
                Vec3d lastHitNormal = SoundPhysics.getNormalFromFacing(rayHit2.func_216354_b());
                Vec3d lastRayDir = rayDir;
                double rayLength = soundPos.func_72438_d(lastHitPos);
                float totalRayDistance = (float)rayLength;
                for (int j = 0; j < 4; ++j) {
                    Vec3d newRayDir = SoundPhysics.reflect(lastRayDir, lastHitNormal);
                    Vec3d newRayStart = new Vec3d(lastHitPos.field_72450_a + lastHitNormal.field_72450_a * 0.01, lastHitPos.field_72448_b + lastHitNormal.field_72448_b * 0.01, lastHitPos.field_72449_c + lastHitNormal.field_72449_c * 0.01);
                    Vec3d newRayEnd = new Vec3d(newRayStart.field_72450_a + newRayDir.field_72450_a * (double)maxDistance, newRayStart.field_72448_b + newRayDir.field_72448_b * (double)maxDistance, newRayStart.field_72449_c + newRayDir.field_72449_c * (double)maxDistance);
                    BlockRayTraceResult newRayHit = SoundPhysics.rayTraceBlocks(newRayStart, newRayEnd, true);
                    float energyTowardsPlayer = 0.25f;
                    float blockReflectivity = SoundPhysics.getBlockReflectivity(lastHitBlock);
                    energyTowardsPlayer *= blockReflectivity * 0.75f + 0.25f;
                    if (newRayHit.func_216346_c() == RayTraceResult.Type.MISS) {
                        totalRayDistance = (float)((double)totalRayDistance + lastHitPos.func_72438_d(playerPos));
                    } else {
                        Vec3d finalRayStart;
                        BlockRayTraceResult finalRayHit;
                        lastHitPos = newRayHit.func_216347_e();
                        lastHitNormal = SoundPhysics.getNormalFromFacing(newRayHit.func_216354_b());
                        lastRayDir = newRayDir;
                        lastHitBlock = newRayHit.func_216350_a();
                        double newRayLength = lastHitPos.func_72438_d(lastHitPos);
                        totalRayDistance = (float)((double)totalRayDistance + newRayLength);
                        int n = j;
                        bounceReflectivityRatio[n] = bounceReflectivityRatio[n] + blockReflectivity;
                        if ((Config.simplerSharedAirspaceSimulation && j == 3 || !Config.simplerSharedAirspaceSimulation) && (finalRayHit = SoundPhysics.rayTraceBlocks(finalRayStart = new Vec3d(lastHitPos.field_72450_a + lastHitNormal.field_72450_a * 0.01, lastHitPos.field_72448_b + lastHitNormal.field_72448_b * 0.01, lastHitPos.field_72449_c + lastHitNormal.field_72449_c * 0.01), playerPos, true)).func_216346_c() == RayTraceResult.Type.MISS) {
                            sharedAirspace += 1.0f;
                        }
                    }
                    float reflectionDelay = (float)Math.max((double)totalRayDistance, 0.0) * 0.12f * blockReflectivity;
                    float cross0 = 1.0f - MathHelper.func_76131_a((float)Math.abs(reflectionDelay - 0.0f), (float)0.0f, (float)1.0f);
                    float cross1 = 1.0f - MathHelper.func_76131_a((float)Math.abs(reflectionDelay - 1.0f), (float)0.0f, (float)1.0f);
                    float cross2 = 1.0f - MathHelper.func_76131_a((float)Math.abs(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                    float cross3 = MathHelper.func_76131_a((float)(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                    sendGain0 += cross0 * energyTowardsPlayer * 6.4f * rcpTotalRays;
                    sendGain1 += cross1 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                    sendGain2 += cross2 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                    sendGain3 += cross3 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                    if (newRayHit.func_216346_c() == RayTraceResult.Type.MISS) continue block3;
                }
            }
            bounceReflectivityRatio[0] = bounceReflectivityRatio[0] / (float)numRays;
            bounceReflectivityRatio[1] = bounceReflectivityRatio[1] / (float)numRays;
            bounceReflectivityRatio[2] = bounceReflectivityRatio[2] / (float)numRays;
            bounceReflectivityRatio[3] = bounceReflectivityRatio[3] / (float)numRays;
            sharedAirspace *= 64.0f;
            sharedAirspace = Config.simplerSharedAirspaceSimulation ? (sharedAirspace *= rcpPrimaryRays) : (sharedAirspace *= rcpTotalRays);
            float sharedAirspaceWeight0 = MathHelper.func_76131_a((float)(sharedAirspace / 20.0f), (float)0.0f, (float)1.0f);
            float sharedAirspaceWeight1 = MathHelper.func_76131_a((float)(sharedAirspace / 15.0f), (float)0.0f, (float)1.0f);
            float sharedAirspaceWeight2 = MathHelper.func_76131_a((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
            float sharedAirspaceWeight3 = MathHelper.func_76131_a((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
            sendCutoff0 = (float)Math.exp(-occlusionAccumulation * absorptionCoeff * 1.0f) * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
            sendCutoff1 = (float)Math.exp(-occlusionAccumulation * absorptionCoeff * 1.0f) * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
            sendCutoff2 = (float)Math.exp(-occlusionAccumulation * absorptionCoeff * 1.5f) * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
            sendCutoff3 = (float)Math.exp(-occlusionAccumulation * absorptionCoeff * 1.5f) * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
            float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
            directCutoff = Math.max((float)Math.pow(averageSharedAirspace, 0.5) * 0.2f, directCutoff);
            directGain = (float)Math.pow(directCutoff, 0.1);
            sendGain1 *= bounceReflectivityRatio[1];
            sendGain2 *= (float)Math.pow(bounceReflectivityRatio[2], 3.0);
            sendGain3 *= (float)Math.pow(bounceReflectivityRatio[3], 4.0);
            sendGain0 = MathHelper.func_76131_a((float)sendGain0, (float)0.0f, (float)1.0f);
            sendGain1 = MathHelper.func_76131_a((float)sendGain1, (float)0.0f, (float)1.0f);
            sendGain2 = MathHelper.func_76131_a((float)(sendGain2 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
            sendGain3 = MathHelper.func_76131_a((float)(sendGain3 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
            sendGain0 *= (float)Math.pow(sendCutoff0, 0.1);
            sendGain1 *= (float)Math.pow(sendCutoff1, 0.1);
            sendGain2 *= (float)Math.pow(sendCutoff2, 0.1);
            sendGain3 *= (float)Math.pow(sendCutoff3, 0.1);
            if (SoundPhysics.mc.field_71439_g.func_70090_H()) {
                sendCutoff0 *= 0.4f;
                sendCutoff1 *= 0.4f;
                sendCutoff2 *= 0.4f;
                sendCutoff3 *= 0.4f;
            }
            SoundPhysics.setEnvironment(sourceID, sendGain0, sendGain1, sendGain2, sendGain3, sendCutoff0, sendCutoff1, sendCutoff2, sendCutoff3, directCutoff, directGain, airAbsorptionFactor);
        }
        catch (Exception e) {
            logger.error("Error while evaluation environment:", (Throwable)e);
            SoundPhysics.setEnvironment(sourceID, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static void setEnvironment(int sourceID, float sendGain0, float sendGain1, float sendGain2, float sendGain3, float sendCutoff0, float sendCutoff1, float sendCutoff2, float sendCutoff3, float directCutoff, float directGain, float airAbsorptionFactor) {
        EXTEfx.alFilterf((int)sendFilter0, (int)1, (float)sendGain0);
        EXTEfx.alFilterf((int)sendFilter0, (int)2, (float)sendCutoff0);
        AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot0, (int)0, (int)sendFilter0);
        EXTEfx.alFilterf((int)sendFilter1, (int)1, (float)sendGain1);
        EXTEfx.alFilterf((int)sendFilter1, (int)2, (float)sendCutoff1);
        AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot1, (int)1, (int)sendFilter1);
        EXTEfx.alFilterf((int)sendFilter2, (int)1, (float)sendGain2);
        EXTEfx.alFilterf((int)sendFilter2, (int)2, (float)sendCutoff2);
        AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot2, (int)2, (int)sendFilter2);
        EXTEfx.alFilterf((int)sendFilter3, (int)1, (float)sendGain3);
        EXTEfx.alFilterf((int)sendFilter3, (int)2, (float)sendCutoff3);
        AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot3, (int)3, (int)sendFilter3);
        EXTEfx.alFilterf((int)directFilter0, (int)1, (float)directGain);
        EXTEfx.alFilterf((int)directFilter0, (int)2, (float)directCutoff);
        AL10.alSourcei((int)sourceID, (int)131077, (int)directFilter0);
        AL10.alSourcef((int)sourceID, (int)131079, (float)MathHelper.func_76131_a((float)(Config.airAbsorption * airAbsorptionFactor), (float)0.0f, (float)10.0f));
        SoundPhysics.checkErrorLog("Error while setting environment for source: " + sourceID);
    }

    protected static void setReverbParams(ReverbParams r, int auxFXSlot, int reverbSlot) {
        EXTEfx.alEffectf((int)reverbSlot, (int)1, (float)r.density);
        SoundPhysics.checkErrorLog("Error while assigning reverb density: " + r.density);
        EXTEfx.alEffectf((int)reverbSlot, (int)2, (float)r.diffusion);
        SoundPhysics.checkErrorLog("Error while assigning reverb diffusion: " + r.diffusion);
        EXTEfx.alEffectf((int)reverbSlot, (int)3, (float)r.gain);
        SoundPhysics.checkErrorLog("Error while assigning reverb gain: " + r.gain);
        EXTEfx.alEffectf((int)reverbSlot, (int)4, (float)r.gainHF);
        SoundPhysics.checkErrorLog("Error while assigning reverb gainHF: " + r.gainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)6, (float)r.decayTime);
        SoundPhysics.checkErrorLog("Error while assigning reverb decayTime: " + r.decayTime);
        EXTEfx.alEffectf((int)reverbSlot, (int)7, (float)r.decayHFRatio);
        SoundPhysics.checkErrorLog("Error while assigning reverb decayHFRatio: " + r.decayHFRatio);
        EXTEfx.alEffectf((int)reverbSlot, (int)9, (float)r.reflectionsGain);
        SoundPhysics.checkErrorLog("Error while assigning reverb reflectionsGain: " + r.reflectionsGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)12, (float)r.lateReverbGain);
        SoundPhysics.checkErrorLog("Error while assigning reverb lateReverbGain: " + r.lateReverbGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)13, (float)r.lateReverbDelay);
        SoundPhysics.checkErrorLog("Error while assigning reverb lateReverbDelay: " + r.lateReverbDelay);
        EXTEfx.alEffectf((int)reverbSlot, (int)19, (float)r.airAbsorptionGainHF);
        SoundPhysics.checkErrorLog("Error while assigning reverb airAbsorptionGainHF: " + r.airAbsorptionGainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)22, (float)r.roomRolloffFactor);
        SoundPhysics.checkErrorLog("Error while assigning reverb roomRolloffFactor: " + r.roomRolloffFactor);
        EXTEfx.alEffectf((int)reverbSlot, (int)15, (float)r.echoTime);
        SoundPhysics.checkErrorLog("Error while assigning reverb echoTime: " + r.echoTime);
        EXTEfx.alEffectf((int)reverbSlot, (int)16, (float)r.echoDepth);
        SoundPhysics.checkErrorLog("Error while assigning reverb echoDepth: " + r.echoDepth);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbSlot);
        SoundPhysics.checkErrorLog("Error while assigning reverb effect slot: " + reverbSlot);
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void logError(String errorMessage) {
        logger.error(errorMessage);
    }

    protected static boolean checkErrorLog(String errorMessage) {
        String errorName;
        int error = AL10.alGetError();
        if (error == 0) {
            return false;
        }
        switch (error) {
            case 40961: {
                errorName = "AL_INVALID_NAME";
                break;
            }
            case 40962: {
                errorName = "AL_INVALID_ENUM";
                break;
            }
            case 40963: {
                errorName = "AL_INVALID_VALUE";
                break;
            }
            case 40964: {
                errorName = "AL_INVALID_OPERATION";
                break;
            }
            case 40965: {
                errorName = "AL_OUT_OF_MEMORY";
                break;
            }
            default: {
                errorName = Integer.toString(error);
            }
        }
        SoundPhysics.logError(errorMessage + " OpenAL error " + errorName);
        return true;
    }

    static {
        attenuationModel = 53250;
        referenceDistance = Config.referenceDistance;
        globalRolloffFactor = Config.rolloffFactor;
        globalVolumeMultiplier0 = Config.globalVolumeMultiplier;
        globalReverbMultiplier = 0.7f * Config.globalReverbGain;
        soundDistanceAllowance = Config.soundDistanceAllowance;
    }
}

