/*
 * Decompiled with CFR 0.152.
 */
package net.tct.matmos.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tct.matmos.MatmosTctMod;
import net.tct.matmos.procedures.CaveSettingsProcedure;
import net.tct.matmos.procedures.InventorySettingsProcedure;
import net.tct.matmos.procedures.MusicSettingsProcedure;
import net.tct.matmos.procedures.NetherSettingsProcedure;
import net.tct.matmos.procedures.SettingsExitProcedure;
import net.tct.matmos.procedures.WaterSettingsProcedure;
import net.tct.matmos.procedures.WindSettingsProcedure;
import net.tct.matmos.world.inventory.GUIMatmosSettingsMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIMatmosSettingsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIMatmosSettingsButtonMessage(PacketBuffer buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIMatmosSettingsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIMatmosSettingsButtonMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIMatmosSettingsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIMatmosSettingsButtonMessage.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        HashMap<String, Object> guistate = GUIMatmosSettingsMenu.guistate;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MusicSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            CaveSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            NetherSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            WaterSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            WindSettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            InventorySettingsProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SettingsExitProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MatmosTctMod.addNetworkMessage(GUIMatmosSettingsButtonMessage.class, GUIMatmosSettingsButtonMessage::buffer, GUIMatmosSettingsButtonMessage::new, GUIMatmosSettingsButtonMessage::handler);
    }
}

