/*
 * Decompiled with CFR 0.152.
 */
package net.tct.matmos.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.tct.matmos.MatmosTctMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MatmosTctModVariables {
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
        MatmosTctMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DesertMusic = message.data.DesertMusic;
                    variables.JungleMusic = message.data.JungleMusic;
                    variables.DesertVillageMusic = message.data.DesertVillageMusic;
                    variables.NetherMusic = message.data.NetherMusic;
                    variables.EndMusic = message.data.EndMusic;
                    variables.BadlandsMusic = message.data.BadlandsMusic;
                    variables.MusicSettings = message.data.MusicSettings;
                    variables.WindSettings = message.data.WindSettings;
                    variables.InventorySettings = message.data.InventorySettings;
                    variables.CaveSettings = message.data.CaveSettings;
                    variables.NetherSettings = message.data.NetherSettings;
                    variables.WaterSettings = message.data.WaterSettings;
                    variables.AmbiantVolume = message.data.AmbiantVolume;
                    variables.PlayerVolume = message.data.PlayerVolume;
                    variables.PlayerTimer = message.data.PlayerTimer;
                    variables.MainItem = message.data.MainItem;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean DesertMusic = false;
        public boolean JungleMusic = false;
        public boolean DesertVillageMusic = false;
        public boolean NetherMusic = false;
        public boolean EndMusic = false;
        public boolean BadlandsMusic = false;
        public boolean MusicSettings = true;
        public boolean WindSettings = true;
        public boolean InventorySettings = true;
        public boolean CaveSettings = true;
        public boolean NetherSettings = true;
        public boolean WaterSettings = true;
        public double AmbiantVolume = 1.0;
        public double PlayerVolume = 1.0;
        public double PlayerTimer = 0.0;
        public ItemStack MainItem = ItemStack.field_190927_a;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                MatmosTctMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("DesertMusic", instance.DesertMusic);
            nbt.func_74757_a("JungleMusic", instance.JungleMusic);
            nbt.func_74757_a("DesertVillageMusic", instance.DesertVillageMusic);
            nbt.func_74757_a("NetherMusic", instance.NetherMusic);
            nbt.func_74757_a("EndMusic", instance.EndMusic);
            nbt.func_74757_a("BadlandsMusic", instance.BadlandsMusic);
            nbt.func_74757_a("MusicSettings", instance.MusicSettings);
            nbt.func_74757_a("WindSettings", instance.WindSettings);
            nbt.func_74757_a("InventorySettings", instance.InventorySettings);
            nbt.func_74757_a("CaveSettings", instance.CaveSettings);
            nbt.func_74757_a("NetherSettings", instance.NetherSettings);
            nbt.func_74757_a("WaterSettings", instance.WaterSettings);
            nbt.func_74780_a("AmbiantVolume", instance.AmbiantVolume);
            nbt.func_74780_a("PlayerVolume", instance.PlayerVolume);
            nbt.func_74780_a("PlayerTimer", instance.PlayerTimer);
            nbt.func_218657_a("MainItem", (INBT)instance.MainItem.func_77955_b(new CompoundNBT()));
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.DesertMusic = nbt.func_74767_n("DesertMusic");
            instance.JungleMusic = nbt.func_74767_n("JungleMusic");
            instance.DesertVillageMusic = nbt.func_74767_n("DesertVillageMusic");
            instance.NetherMusic = nbt.func_74767_n("NetherMusic");
            instance.EndMusic = nbt.func_74767_n("EndMusic");
            instance.BadlandsMusic = nbt.func_74767_n("BadlandsMusic");
            instance.MusicSettings = nbt.func_74767_n("MusicSettings");
            instance.WindSettings = nbt.func_74767_n("WindSettings");
            instance.InventorySettings = nbt.func_74767_n("InventorySettings");
            instance.CaveSettings = nbt.func_74767_n("CaveSettings");
            instance.NetherSettings = nbt.func_74767_n("NetherSettings");
            instance.WaterSettings = nbt.func_74767_n("WaterSettings");
            instance.AmbiantVolume = nbt.func_74769_h("AmbiantVolume");
            instance.PlayerVolume = nbt.func_74769_h("PlayerVolume");
            instance.PlayerTimer = nbt.func_74769_h("PlayerTimer");
            instance.MainItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("MainItem"));
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("matmos_tct", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null, nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().field_70170_p.field_72995_K) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().field_70170_p.field_72995_K) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().field_70170_p.field_72995_K) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.DesertMusic = original.DesertMusic;
            clone.JungleMusic = original.JungleMusic;
            clone.DesertVillageMusic = original.DesertVillageMusic;
            clone.NetherMusic = original.NetherMusic;
            clone.EndMusic = original.EndMusic;
            clone.BadlandsMusic = original.BadlandsMusic;
            clone.MusicSettings = original.MusicSettings;
            clone.WindSettings = original.WindSettings;
            clone.InventorySettings = original.InventorySettings;
            clone.CaveSettings = original.CaveSettings;
            clone.NetherSettings = original.NetherSettings;
            clone.WaterSettings = original.WaterSettings;
            clone.AmbiantVolume = original.AmbiantVolume;
            clone.PlayerVolume = original.PlayerVolume;
            if (!event.isWasDeath()) {
                clone.PlayerTimer = original.PlayerTimer;
                clone.MainItem = original.MainItem;
            }
        }
    }
}

