/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zerosbunchostuff.block;

import net.mcreator.zerosbunchostuff.procedures.CopperWindChimesOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WarpedCopperWindChimesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public WarpedCopperWindChimesBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 10.0f).noOcclusion().randomTicks().isRedstoneConductor((bs, br, bp) -> false).ignitedByLava().instrument(NoteBlockInstrument.CHIME));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)WarpedCopperWindChimesBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WarpedCopperWindChimesBlock.box((double)5.75, (double)12.0, (double)5.75, (double)6.25, (double)14.0, (double)6.25), WarpedCopperWindChimesBlock.box((double)5.0, (double)2.0, (double)5.0, (double)7.0, (double)12.0, (double)7.0), WarpedCopperWindChimesBlock.box((double)7.0, (double)4.0, (double)9.0, (double)9.0, (double)12.0, (double)11.0), WarpedCopperWindChimesBlock.box((double)7.75, (double)12.0, (double)9.75, (double)8.25, (double)14.0, (double)10.25), WarpedCopperWindChimesBlock.box((double)9.0, (double)6.0, (double)6.0, (double)11.0, (double)12.0, (double)8.0), WarpedCopperWindChimesBlock.box((double)9.75, (double)12.0, (double)6.75, (double)10.25, (double)14.0, (double)7.25)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WarpedCopperWindChimesBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WarpedCopperWindChimesBlock.box((double)9.75, (double)12.0, (double)9.75, (double)10.25, (double)14.0, (double)10.25), WarpedCopperWindChimesBlock.box((double)9.0, (double)2.0, (double)9.0, (double)11.0, (double)12.0, (double)11.0), WarpedCopperWindChimesBlock.box((double)7.0, (double)4.0, (double)5.0, (double)9.0, (double)12.0, (double)7.0), WarpedCopperWindChimesBlock.box((double)7.75, (double)12.0, (double)5.75, (double)8.25, (double)14.0, (double)6.25), WarpedCopperWindChimesBlock.box((double)5.0, (double)6.0, (double)8.0, (double)7.0, (double)12.0, (double)10.0), WarpedCopperWindChimesBlock.box((double)5.75, (double)12.0, (double)8.75, (double)6.25, (double)14.0, (double)9.25)});
            case Direction.EAST -> Shapes.or((VoxelShape)WarpedCopperWindChimesBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WarpedCopperWindChimesBlock.box((double)5.75, (double)12.0, (double)9.75, (double)6.25, (double)14.0, (double)10.25), WarpedCopperWindChimesBlock.box((double)5.0, (double)2.0, (double)9.0, (double)7.0, (double)12.0, (double)11.0), WarpedCopperWindChimesBlock.box((double)9.0, (double)4.0, (double)7.0, (double)11.0, (double)12.0, (double)9.0), WarpedCopperWindChimesBlock.box((double)9.75, (double)12.0, (double)7.75, (double)10.25, (double)14.0, (double)8.25), WarpedCopperWindChimesBlock.box((double)6.0, (double)6.0, (double)5.0, (double)8.0, (double)12.0, (double)7.0), WarpedCopperWindChimesBlock.box((double)6.75, (double)12.0, (double)5.75, (double)7.25, (double)14.0, (double)6.25)});
            case Direction.WEST -> Shapes.or((VoxelShape)WarpedCopperWindChimesBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WarpedCopperWindChimesBlock.box((double)9.75, (double)12.0, (double)5.75, (double)10.25, (double)14.0, (double)6.25), WarpedCopperWindChimesBlock.box((double)9.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)7.0), WarpedCopperWindChimesBlock.box((double)5.0, (double)4.0, (double)7.0, (double)7.0, (double)12.0, (double)9.0), WarpedCopperWindChimesBlock.box((double)5.75, (double)12.0, (double)7.75, (double)6.25, (double)14.0, (double)8.25), WarpedCopperWindChimesBlock.box((double)8.0, (double)6.0, (double)9.0, (double)10.0, (double)12.0, (double)11.0), WarpedCopperWindChimesBlock.box((double)8.75, (double)12.0, (double)9.75, (double)9.25, (double)14.0, (double)10.25)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(blockstate, world, pos, random);
        CopperWindChimesOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

