/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zerosbunchostuff.client.renderer;

import net.mcreator.zerosbunchostuff.client.model.ModelLurker3;
import net.mcreator.zerosbunchostuff.client.model.animations.Lurker2Animation;
import net.mcreator.zerosbunchostuff.client.model.animations.LurkerBetBetterAnimation;
import net.mcreator.zerosbunchostuff.entity.LurkerEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class LurkerRenderer
extends MobRenderer<LurkerEntity, ModelLurker3<LurkerEntity>> {
    public LurkerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelLurker3.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(LurkerEntity entity) {
        return ResourceLocation.parse((String)"zeros_bunch_o_stuff:textures/entities/lurkertexture.png");
    }

    private static final class AnimatedModel
    extends ModelLurker3<LurkerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<LurkerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(LurkerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(Lurker2Animation.LurkerWalkBetter, limbSwing, limbSwingAmount, 8.0f, 4.0f);
                this.animate(entity.animationState1, LurkerBetBetterAnimation.LurkerIdleBetBetter, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(LurkerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

