/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zerosbunchostuff.init;

import net.mcreator.zerosbunchostuff.potion.EchoingSightMobEffect;
import net.mcreator.zerosbunchostuff.potion.GigantismMobEffect;
import net.mcreator.zerosbunchostuff.potion.HungerBoosterMobEffect;
import net.mcreator.zerosbunchostuff.procedures.EchoingSightSoundProcedure;
import net.mcreator.zerosbunchostuff.procedures.GiganticGoldenApplePlayerFinishesEffectProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ZerosBunchOStuffModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"zeros_bunch_o_stuff");
    public static final DeferredHolder<MobEffect, MobEffect> ECHOING_SIGHT = REGISTRY.register("echoing_sight", () -> new EchoingSightMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HUNGER_BOOSTER = REGISTRY.register("hunger_booster", () -> new HungerBoosterMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GIGANTISM = REGISTRY.register("gigantism", () -> new GigantismMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ZerosBunchOStuffModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ZerosBunchOStuffModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ECHOING_SIGHT)) {
            EchoingSightSoundProcedure.execute((LevelAccessor)entity.level(), entity);
        } else if (effectInstance.getEffect().is(GIGANTISM)) {
            GiganticGoldenApplePlayerFinishesEffectProcedure.execute(entity);
        }
    }
}

