/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.loader.api.FabricLoader;
import org.purpurmc.purpur.client.config.Config;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class ConfigManager {
    private Path configFile;
    private Path backupConfigFile;
    private Config config;

    private static HoconConfigurationLoader loader(Path path) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).build();
    }

    public Config getConfig() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void reload() {
        Path config;
        try {
            config = this.getConfigFile();
        }
        catch (IOException e) {
            throw ConfigManager.rethrow(e);
        }
        boolean hasConfigVersion = false;
        try {
            HoconConfigurationLoader loader = ConfigManager.loader(config);
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            hasConfigVersion = node.hasChild(new Object[]{"config-version"});
            this.config = (Config)node.get(Config.class);
        }
        catch (IOException e) {
            ConfigManager.rethrow(e);
        }
        if (Files.exists(config, new LinkOption[0]) && !hasConfigVersion) {
            try {
                Path backupConfig = this.getBackupConfigFile();
                Files.copy(this.configFile, backupConfig, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ConfigManager.rethrow(e);
            }
            this.config.seats.setAllSeats(0.0, 0.0, 0.0);
        }
        this.save();
    }

    public void save() {
        HoconConfigurationLoader loader = ConfigManager.loader(this.configFile);
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.createNode();
        try {
            node.set((Object)this.config);
            loader.save((ConfigurationNode)node);
        }
        catch (IOException e) {
            ConfigManager.rethrow(e);
        }
    }

    private Path getBackupConfigFile() throws IOException {
        if (this.backupConfigFile != null) {
            return this.backupConfigFile;
        }
        Path configDir = FabricLoader.getInstance().getConfigDir();
        this.backupConfigFile = configDir.resolve("purpurclient.conf.backup");
        return this.backupConfigFile;
    }

    private Path getConfigFile() throws IOException {
        if (this.configFile != null) {
            return this.configFile;
        }
        Path configDir = FabricLoader.getInstance().getConfigDir();
        this.configFile = configDir.resolve("purpurclient.conf");
        return this.configFile;
    }

    public static <X extends Throwable> RuntimeException rethrow(Throwable t) throws X {
        throw t;
    }
}

