/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.commands;

import com.axalotl.async.ParallelProcessor;
import com.axalotl.async.commands.AsyncCommand;
import com.axalotl.async.config.AsyncConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatsCommand {
    private static final Logger LOGGER = LogManager.getLogger(StatsCommand.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,##0.##");
    private static final int MAX_SAMPLES = 100;
    private static final long SAMPLING_INTERVAL_MS = 10L;
    private static final Queue<Integer> threadSamples = new ConcurrentLinkedQueue<Integer>();
    private static volatile boolean isRunning = true;
    private static Thread statsThread;

    public static LiteralArgumentBuilder<class_2168> registerStatus(LiteralArgumentBuilder<class_2168> root) {
        return (LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(cmdSrc -> cmdSrc.method_9259(4))).executes(cmdCtx -> {
            StatsCommand.showGeneralStats((class_2168)cmdCtx.getSource());
            return 1;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entity").requires(cmdSrc -> cmdSrc.method_9259(4))).executes(cmdCtx -> {
            StatsCommand.showEntityStats((class_2168)cmdCtx.getSource(), 0);
            return 1;
        })).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(cmdCtx -> {
            int count = IntegerArgumentType.getInteger((CommandContext)cmdCtx, (String)"count");
            StatsCommand.showEntityStats((class_2168)cmdCtx.getSource(), count);
            return 1;
        }))));
    }

    private static void showGeneralStats(class_2168 source) {
        int availableProcessors = AsyncConfig.getParallelism();
        double avgThreads = StatsCommand.calculateAverageThreads();
        double threadUtilization = avgThreads / (double)availableProcessors * 100.0;
        class_5250 message = AsyncCommand.prefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Performance Statistics ").method_27694(style -> style.method_10977(class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)"\nActive Processing Threads: ").method_27694(style -> style.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)DECIMAL_FORMAT.format(avgThreads)).method_27694(style -> style.method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)(" / " + availableProcessors)).method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)"\nThread Utilization: ").method_27694(style -> style.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)(DECIMAL_FORMAT.format(threadUtilization) + "%")).method_27694(style -> style.method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"\nAsync Status: ").method_27694(style -> style.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)(AsyncConfig.disabled ? "Disabled" : "Enabled")).method_27694(style -> style.method_10977(AsyncConfig.disabled ? class_124.field_1061 : class_124.field_1060)));
        source.method_9226(() -> message, true);
    }

    private static void showEntityStats(class_2168 source, int topCount) {
        MinecraftServer server = source.method_9211();
        server.execute(() -> {
            HashMap entityTypeCounts = new HashMap();
            HashMap asyncEntityTypeCounts = new HashMap();
            AtomicInteger totalEntities = new AtomicInteger(0);
            AtomicInteger totalAsyncEntities = new AtomicInteger(0);
            class_5250 message = AsyncCommand.prefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Entity Statistics ").method_27694(style -> style.method_10977(class_124.field_1065)));
            server.method_3738().forEach(world -> {
                String worldName = world.method_27983().method_29177().toString();
                AtomicInteger worldCount = new AtomicInteger(0);
                AtomicInteger asyncCount = new AtomicInteger(0);
                world.field_26934.method_31791(entity -> {
                    if (entity != null && entity.method_5805()) {
                        class_1299 entityType = entity.method_5864();
                        worldCount.incrementAndGet();
                        totalEntities.incrementAndGet();
                        entityTypeCounts.merge(entityType, 1, Integer::sum);
                        if (!ParallelProcessor.shouldTickSynchronously(entity)) {
                            asyncCount.incrementAndGet();
                            totalAsyncEntities.incrementAndGet();
                            asyncEntityTypeCounts.merge(entityType, 1, Integer::sum);
                        }
                    }
                });
                message.method_10852((class_2561)class_2561.method_43470((String)("\n" + worldName + ": ")).method_27694(style -> style.method_10977(class_124.field_1054))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(worldCount.get())).method_27694(style -> style.method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)" entities (").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(asyncCount.get())).method_27694(style -> style.method_10977(class_124.field_1075))).method_10852((class_2561)class_2561.method_43470((String)" async)").method_27694(style -> style.method_10977(class_124.field_1080)));
            });
            message.method_10852((class_2561)class_2561.method_43470((String)"\nTotal Entities: ").method_27694(style -> style.method_10977(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(totalEntities.get())).method_27694(style -> style.method_10977(class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)" (").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(totalAsyncEntities.get())).method_27694(style -> style.method_10977(class_124.field_1075))).method_10852((class_2561)class_2561.method_43470((String)" async)").method_27694(style -> style.method_10977(class_124.field_1080)));
            if (topCount > 0) {
                List sortedEntities = new ArrayList(entityTypeCounts.entrySet());
                sortedEntities.sort(Map.Entry.comparingByValue().reversed());
                if (topCount < sortedEntities.size()) {
                    sortedEntities = sortedEntities.subList(0, topCount);
                }
                if (!sortedEntities.isEmpty()) {
                    message.method_10852((class_2561)class_2561.method_43470((String)("\n\nTop " + sortedEntities.size() + " Entity Types:")).method_27694(style -> style.method_10977(class_124.field_1065)));
                    int rank = 1;
                    for (Map.Entry entry : sortedEntities) {
                        class_1299 type = (class_1299)entry.getKey();
                        int count = (Integer)entry.getValue();
                        int asyncCount = asyncEntityTypeCounts.getOrDefault(type, 0);
                        class_2960 typeId = class_7923.field_41177.method_10221((Object)type);
                        String name = typeId.toString();
                        message.method_10852((class_2561)class_2561.method_43470((String)("\n" + rank + ". ")).method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_10977(class_124.field_1054))).method_10852((class_2561)class_2561.method_43470((String)": ").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count)).method_27694(style -> style.method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)" (").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(asyncCount)).method_27694(style -> style.method_10977(class_124.field_1075))).method_10852((class_2561)class_2561.method_43470((String)" async)").method_27694(style -> style.method_10977(class_124.field_1080)));
                        ++rank;
                    }
                }
            }
            source.method_9226(() -> message, true);
        });
    }

    private static double calculateAverageThreads() {
        if (threadSamples.isEmpty()) {
            return 0.0;
        }
        double sum = threadSamples.stream().mapToDouble(Integer::doubleValue).sum();
        return sum / (double)threadSamples.size();
    }

    public static void runStatsThread() {
        if (statsThread != null && statsThread.isAlive()) {
            return;
        }
        statsThread = new Thread(() -> {
            while (isRunning && !Thread.currentThread().isInterrupted()) {
                try {
                    StatsCommand.updateStats();
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error in stats thread", (Throwable)e);
                }
            }
        }, "Async-Stats-Thread");
        statsThread.setDaemon(true);
        statsThread.start();
    }

    private static void updateStats() {
        if (AsyncConfig.disabled) {
            StatsCommand.resetStats();
            return;
        }
        int currentThreads = ParallelProcessor.currentEntities.get();
        threadSamples.offer(currentThreads);
        while (threadSamples.size() > 100) {
            threadSamples.poll();
        }
    }

    private static void resetStats() {
        threadSamples.clear();
    }

    public static void shutdown() {
        isRunning = false;
        if (statsThread != null) {
            statsThread.interrupt();
        }
    }
}

