/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.mixin.entity;

import com.axalotl.async.config.AsyncConfig;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Unique
    private static final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"move"})
    private void move(class_1313 type, class_243 movement, Operation<Void> original) {
        if (AsyncConfig.enableEntityMoveSync) {
            ReentrantLock reentrantLock = lock;
            synchronized (reentrantLock) {
                original.call(new Object[]{type, movement});
            }
        } else {
            original.call(new Object[]{type, movement});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"tickBlockCollision()V"})
    private void tickBlockCollision(Operation<Void> original) {
        if (AsyncConfig.enableEntityMoveSync) {
            ReentrantLock reentrantLock = lock;
            synchronized (reentrantLock) {
                original.call(new Object[0]);
            }
        } else {
            original.call(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"tickBlockCollision(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;)V"})
    private void tickBlockCollision(class_243 lastRenderPos, class_243 pos, Operation<Void> original) {
        if (AsyncConfig.enableEntityMoveSync) {
            ReentrantLock reentrantLock = lock;
            synchronized (reentrantLock) {
                original.call(new Object[]{lastRenderPos, pos});
            }
        } else {
            original.call(new Object[]{lastRenderPos, pos});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"setRemoved"})
    private void setRemoved(class_1297.class_5529 reason, Operation<Void> original) {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            original.call(new Object[]{reason});
        }
    }

    @WrapMethod(method={"getBlockStateAtPos"})
    private class_2680 getBlockStateAtPos(Operation<class_2680> original) {
        class_2680 blockState = (class_2680)original.call(new Object[0]);
        if (blockState != null) {
            return blockState;
        }
        return class_2246.field_10124.method_9564();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"addPassenger"})
    private void addPassenger(class_1297 passenger, Operation<Void> original) {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            original.call(new Object[]{passenger});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"removePassenger"})
    private void removePassenger(class_1297 passenger, Operation<Void> original) {
        ReentrantLock reentrantLock = lock;
        synchronized (reentrantLock) {
            original.call(new Object[]{passenger});
        }
    }
}

