/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.parallelised.fastutil;

import com.axalotl.async.parallelised.fastutil.FastUtilHackUtil;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;

public class ConcurrentLongLinkedOpenHashSet
extends LongLinkedOpenHashSet {
    private final ConcurrentSkipListSet<Long> backing = new ConcurrentSkipListSet();

    public boolean add(long k) {
        return this.backing.add(k);
    }

    public boolean addAll(Collection<? extends Long> c) {
        Objects.requireNonNull(c, "Collection cannot be null");
        return this.backing.addAll(c);
    }

    public boolean contains(long k) {
        return this.backing.contains(k);
    }

    public boolean remove(long k) {
        return this.backing.remove(k);
    }

    public void clear() {
        this.backing.clear();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public int size() {
        return this.backing.size();
    }

    public long firstLong() {
        return Optional.ofNullable(this.backing.first()).orElseThrow(() -> new NoSuchElementException("Set is empty"));
    }

    public long lastLong() {
        return Optional.ofNullable(this.backing.last()).orElseThrow(() -> new NoSuchElementException("Set is empty"));
    }

    public long removeFirstLong() {
        long first = this.firstLong();
        this.backing.remove(first);
        return first;
    }

    public long removeLastLong() {
        long last = this.lastLong();
        this.backing.remove(last);
        return last;
    }

    @NotNull
    public LongListIterator iterator() {
        return FastUtilHackUtil.wrap(this.backing.iterator());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ConcurrentLongLinkedOpenHashSet)) return false;
        ConcurrentLongLinkedOpenHashSet other = (ConcurrentLongLinkedOpenHashSet)((Object)obj);
        if (!this.backing.equals(other.backing)) return false;
        return true;
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.backing.toString();
    }
}

