/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.api.definitions.interfaces.EventTask;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonEntity;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class EaseonEntityInteract {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<EntityInteractTask> _beforeTasks = new CopyOnWriteArrayList<EntityInteractTask>();
    private static final List<EntityInteractTask> _afterTasks = new CopyOnWriteArrayList<EntityInteractTask>();

    public static EntityInteractTask on(EventPhase phase, EntityInteractRunnableWrapper task) {
        EntityInteractTask entityInteractTask = new EntityInteractTask((player, world, target, hand) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), hand, new EaseonEntity(target)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(entityInteractTask);
        } else {
            _afterTasks.add(entityInteractTask);
        }
        return entityInteractTask;
    }

    public static void off(EntityInteractTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static class_1269 onEntityInteractBefore(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
        return EaseonEntityInteract.executeTasks(_beforeTasks, player, world, target, hand, "BEFORE");
    }

    public static class_1269 onEntityInteractAfter(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
        return EaseonEntityInteract.executeTasks(_afterTasks, player, world, target, hand, "AFTER");
    }

    private static class_1269 executeTasks(List<EntityInteractTask> tasks, class_3222 player, class_1937 world, class_1297 target, class_1268 hand, String phase) {
        for (EntityInteractTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, target, hand);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in entity interact task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class EntityInteractTask
    implements EventTask {
        private final EntityInteractRunnable _task;

        public EntityInteractTask(EntityInteractRunnable task) {
            this._task = task;
        }

        public class_1269 execute(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
            return this._task.run(player, world, target, hand);
        }

        @Override
        public EventTask remove() {
            EaseonEntityInteract.off(this);
            return null;
        }
    }

    @FunctionalInterface
    public static interface EntityInteractRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, class_1268 var3, EaseonEntity var4);
    }

    @FunctionalInterface
    public static interface EntityInteractRunnable {
        public class_1269 run(class_3222 var1, class_1937 var2, class_1297 var3, class_1268 var4);
    }
}

