/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.api.definitions.interfaces.EventTask;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonEntity;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_3218;

public class EaseonEntitySpawn {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<EntitySpawnTask> _beforeTasks = new CopyOnWriteArrayList<EntitySpawnTask>();
    private static final List<EntitySpawnTask> _afterTasks = new CopyOnWriteArrayList<EntitySpawnTask>();

    public static EntitySpawnTask on(EventPhase phase, EntitySpawnRunnableWrapper task) {
        EntitySpawnTask spawnTask = new EntitySpawnTask((entity, world) -> task.run(new EaseonWorld(world), new EaseonEntity(entity)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(spawnTask);
        } else {
            _afterTasks.add(spawnTask);
        }
        return spawnTask;
    }

    public static void off(EntitySpawnTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static class_1269 onEntitySpawnBefore(class_1297 entity, class_3218 world) {
        for (EntitySpawnTask task : _beforeTasks) {
            try {
                class_1269 result = task.run(entity, world);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error executing BEFORE EntitySpawn task", e);
            }
        }
        return class_1269.field_5811;
    }

    public static void onEntitySpawnAfter(class_1297 entity, class_3218 world) {
        for (EntitySpawnTask task : _afterTasks) {
            try {
                task.run(entity, world);
            }
            catch (Exception e) {
                logger.error("Error executing AFTER EntitySpawn task", e);
            }
        }
    }

    public static class EntitySpawnTask
    implements EventTask {
        private final EntitySpawnRunnable task;

        public EntitySpawnTask(EntitySpawnRunnable task) {
            this.task = task;
        }

        public class_1269 run(class_1297 entity, class_3218 world) {
            return this.task.run(entity, world);
        }

        @Override
        public EventTask remove() {
            EaseonEntitySpawn.off(this);
            return null;
        }
    }

    @FunctionalInterface
    public static interface EntitySpawnRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonEntity var2);
    }

    @FunctionalInterface
    public static interface EntitySpawnRunnable {
        public class_1269 run(class_1297 var1, class_3218 var2);
    }
}

