/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.helper;

import com.easeon.ss.core.wrapper.EaseonBlock;
import com.easeon.ss.core.wrapper.EaseonItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class CopperHelper {
    private final List<class_2248> ALL_COPPER_BLOCKS = new ArrayList<class_2248>();
    private final Map<class_2248, BlockInfo> BLOCK_INFO = new HashMap<class_2248, BlockInfo>();
    private final int GROUP_SIZE = 8;
    private static CopperHelper instance;

    public static void init() {
        if (instance == null) {
            instance = new CopperHelper();
            instance.registerCopperGroup(false, class_2246.field_27119, class_2246.field_27118, class_2246.field_27117, class_2246.field_27116, class_2246.field_27133, class_2246.field_27135, class_2246.field_27134, class_2246.field_33407);
            instance.registerCopperGroup(false, class_2246.field_27124, class_2246.field_27123, class_2246.field_27122, class_2246.field_27121, class_2246.field_27138, class_2246.field_27137, class_2246.field_27136, class_2246.field_33408);
            instance.registerCopperGroup(false, class_2246.field_27128, class_2246.field_27127, class_2246.field_27126, class_2246.field_27125, class_2246.field_27167, class_2246.field_27166, class_2246.field_27139, class_2246.field_33409);
            instance.registerCopperGroup(false, class_2246.field_27132, class_2246.field_27131, class_2246.field_27130, class_2246.field_27129, class_2246.field_27170, class_2246.field_27169, class_2246.field_27168, class_2246.field_33410);
            instance.registerCopperGroup(false, class_2246.field_47072, class_2246.field_47073, class_2246.field_47074, class_2246.field_47075, class_2246.field_47076, class_2246.field_47077, class_2246.field_47078, class_2246.field_47079);
            instance.registerCopperGroup(true, class_2246.field_47040, class_2246.field_47041, class_2246.field_47043, class_2246.field_47042, class_2246.field_47044, class_2246.field_47045, class_2246.field_47047, class_2246.field_47046);
            instance.registerCopperGroup(true, class_2246.field_47048, class_2246.field_47049, class_2246.field_47051, class_2246.field_47050, class_2246.field_47052, class_2246.field_47053, class_2246.field_47063, class_2246.field_47062);
            instance.registerCopperGroup(false, class_2246.field_47064, class_2246.field_47065, class_2246.field_47066, class_2246.field_47067, class_2246.field_47068, class_2246.field_47069, class_2246.field_47070, class_2246.field_47071);
            instance.registerCopperGroup(false, class_2246.field_47057, class_2246.field_47056, class_2246.field_47055, class_2246.field_47054, class_2246.field_47061, class_2246.field_47060, class_2246.field_47059, class_2246.field_47058);
            instance.registerCopperGroup(true, class_2246.field_61388, class_2246.field_61389, class_2246.field_61390, class_2246.field_61391, class_2246.field_61392, class_2246.field_61393, class_2246.field_61394, class_2246.field_61395);
            instance.registerCopperGroup(false, class_2246.field_61904.comp_4576(), class_2246.field_61904.comp_4577(), class_2246.field_61904.comp_4578(), class_2246.field_61904.comp_4579(), class_2246.field_61904.comp_4580(), class_2246.field_61904.comp_4581(), class_2246.field_61904.comp_4582(), class_2246.field_61904.comp_4583());
            instance.registerCopperGroup(false, class_2246.field_61905.comp_4576(), class_2246.field_61905.comp_4577(), class_2246.field_61905.comp_4578(), class_2246.field_61905.comp_4579(), class_2246.field_61905.comp_4580(), class_2246.field_61905.comp_4581(), class_2246.field_61905.comp_4582(), class_2246.field_61905.comp_4583());
            instance.registerCopperGroup(false, class_2246.field_61906.comp_4576(), class_2246.field_61906.comp_4577(), class_2246.field_61906.comp_4578(), class_2246.field_61906.comp_4579(), class_2246.field_61906.comp_4580(), class_2246.field_61906.comp_4581(), class_2246.field_61906.comp_4582(), class_2246.field_61906.comp_4583());
            instance.registerCopperGroup(true, class_2246.field_61396, class_2246.field_61397, class_2246.field_61398, class_2246.field_61399, class_2246.field_61400, class_2246.field_61378, class_2246.field_61379, class_2246.field_61380);
            instance.registerCopperGroup(false, class_2246.field_27171, class_2246.field_61381, class_2246.field_61382, class_2246.field_61383, class_2246.field_61384, class_2246.field_61385, class_2246.field_61386, class_2246.field_61387);
        }
    }

    private void registerCopperGroup(boolean isSneaking, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            int index = this.ALL_COPPER_BLOCKS.size();
            this.BLOCK_INFO.put(block, new BlockInfo(index, isSneaking));
            this.ALL_COPPER_BLOCKS.add(block);
        }
    }

    public static Optional<EaseonBlock> oxidize(EaseonItem item) {
        int pos;
        BlockInfo info = CopperHelper.instance.BLOCK_INFO.get(item.getBlock());
        if (info != null && (pos = info.index % CopperHelper.instance.GROUP_SIZE) >= 0 && pos <= 2) {
            return Optional.of(new EaseonBlock(CopperHelper.instance.ALL_COPPER_BLOCKS.get(info.index + 1)));
        }
        return Optional.empty();
    }

    public static Optional<EaseonBlock> deoxidize(EaseonItem item) {
        int pos;
        BlockInfo info = CopperHelper.instance.BLOCK_INFO.get(item.getBlock());
        if (info != null && (pos = info.index % CopperHelper.instance.GROUP_SIZE) >= 1 && pos <= 3) {
            return Optional.of(new EaseonBlock(CopperHelper.instance.ALL_COPPER_BLOCKS.get(info.index - 1)));
        }
        return Optional.empty();
    }

    public static Optional<EaseonBlock> removeWax(EaseonItem item) {
        int pos;
        BlockInfo info = CopperHelper.instance.BLOCK_INFO.get(item.getBlock());
        if (info != null && (pos = info.index % CopperHelper.instance.GROUP_SIZE) >= 4) {
            return Optional.of(new EaseonBlock(CopperHelper.instance.ALL_COPPER_BLOCKS.get(info.index - 4)));
        }
        return Optional.empty();
    }

    public static int getIndex(EaseonItem item) {
        BlockInfo info = CopperHelper.instance.BLOCK_INFO.get(item.getBlock());
        return info != null ? info.index : -1;
    }

    public static boolean isSneakingRequired(EaseonItem item) {
        BlockInfo info = CopperHelper.instance.BLOCK_INFO.get(item.getBlock());
        return info != null && info.isSneaking;
    }

    public static boolean isCopper(EaseonItem item) {
        return CopperHelper.instance.BLOCK_INFO.containsKey(item.getBlock());
    }

    public static class BlockInfo {
        public final int index;
        public final boolean isSneaking;

        BlockInfo(int index, boolean isSneaking) {
            this.index = index;
            this.isSneaking = isSneaking;
        }
    }
}

