/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.util.system;

import com.easeon.ss.core.helper.StringHelper;
import com.easeon.ss.core.util.mod.EaseonModInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaseonLogger {
    private final Logger logger;

    public EaseonLogger(String modName) {
        this.logger = LoggerFactory.getLogger((String)modName);
    }

    public static EaseonLogger of() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String className = caller.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            EaseonModInfo info = EaseonModInfo.of(clazz);
            return new EaseonLogger(info.name.replace(" ", "") + "/" + clazz.getSimpleName());
        }
        catch (ClassNotFoundException e) {
            return new EaseonLogger(className.substring(className.lastIndexOf(46) + 1));
        }
    }

    public static EaseonLogger of(String className) {
        try {
            String modId = StringHelper.extractModId(className);
            EaseonModInfo info = EaseonModInfo.of(modId);
            Class<?> clazz = Class.forName(className);
            String loggerName = info.name.replace(" ", "") + "/" + clazz.getSimpleName();
            return new EaseonLogger(loggerName);
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            return new EaseonLogger(className.substring(className.lastIndexOf(46) + 1));
        }
    }

    public void info(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.logger.info("{}", (Object)String.format(msg, args));
    }

    public void warn(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.logger.warn("{}", (Object)String.format(msg, args));
    }

    public void error(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.logger.error("{}", (Object)String.format(msg, args));
    }

    public void error(String message, Throwable throwable) {
        this.logger.error("{}", (Object)message, (Object)throwable);
    }

    public void debug(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.logger.debug("{}", (Object)String.format(msg, args));
    }
}

