/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.common;

import com.easeon.ss.core.util.system.EaseonLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class EaseonConfig {
    private static final EaseonLogger logger = EaseonLogger.get(EaseonConfig.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Class<? extends EaseonConfig>, EaseonConfig> instances = new HashMap<Class<? extends EaseonConfig>, EaseonConfig>();
    protected transient String configPath;

    protected EaseonConfig() {
        try {
            this.configPath = (String)this.getClass().getDeclaredField("CONFIG_PATH").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("CONFIG_PATH not found", new Object[0]);
            throw new RuntimeException("CONFIG_PATH not found");
        }
    }

    public static <T extends EaseonConfig> T getInstance(Class<T> configClass) {
        if (!instances.containsKey(configClass)) {
            try {
                EaseonConfig instance = (EaseonConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance.load();
                instances.put(configClass, instance);
            }
            catch (Exception e) {
                logger.error("Failed to create instance: {}", e);
                throw new RuntimeException("Failed to create config instance", e);
            }
        }
        return (T)instances.get(configClass);
    }

    public void load() {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            EaseonConfig loaded = (EaseonConfig)GSON.fromJson((Reader)reader, this.getClass());
            if (loaded != null) {
                this.copyFields(loaded);
            }
        }
        catch (IOException e) {
            logger.error("Failed to load config: {}", e);
        }
    }

    public void save() {
        try {
            File configFile = new File(this.configPath);
            File parentDir = configFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                logger.error("Failed to create config directory", new Object[0]);
                return;
            }
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            logger.error("Failed to save config: {}", new Object[0]);
        }
    }

    private void copyFields(EaseonConfig loaded) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(this, field.get(loaded));
            }
        }
        catch (IllegalAccessException e) {
            logger.error("Failed to copy fields: {}", e);
        }
    }
}

