/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.util.system.EaseonLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;

public class EaseonServerTick {
    private static final EaseonLogger logger = EaseonLogger.get();
    private static final List<TickTask> _tasks = new CopyOnWriteArrayList<TickTask>();
    private static final Map<Object, TickTask> _methodRefTasks = new HashMap<Object, TickTask>();

    public static TickTask register(TickRunnable task) {
        return EaseonServerTick.register(1, task);
    }

    public static TickTask register(int interval, TickRunnable task) {
        TickTask tickTask = new TickTask(interval, task);
        _tasks.add(tickTask);
        _methodRefTasks.put(task, tickTask);
        return tickTask;
    }

    public static void register(TickTask task) {
        if (!_tasks.contains(task)) {
            _tasks.add(task);
        }
    }

    public static void unregister(TickTask task) {
        _tasks.remove(task);
    }

    public static void unregister(TickRunnable task) {
        TickTask tickTask = _methodRefTasks.remove(task);
        if (tickTask != null) {
            _tasks.remove(tickTask);
        }
    }

    public static void onTick(MinecraftServer server) {
        for (TickTask task : _tasks) {
            try {
                task.tick(server);
            }
            catch (Exception e) {
                logger.error("Error in tick task: {}", e);
            }
        }
    }

    @FunctionalInterface
    public static interface TickRunnable {
        public void run(MinecraftServer var1);
    }

    public static class TickTask {
        private final int _interval;
        private final TickRunnable _task;
        private int _counter = 0;

        public TickTask(int interval, TickRunnable task) {
            this._interval = interval;
            this._task = task;
        }

        public void tick(MinecraftServer server) {
            ++this._counter;
            if (this._counter >= this._interval) {
                this._task.run(server);
                this._counter = 0;
            }
        }
    }
}

