/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.registry;

import com.easeon.ss.core.util.system.EaseonLogger;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;

public class EaseonCommand {
    private static final EaseonLogger logger = EaseonLogger.get();
    private static final List<CommandRegistrar> registrars = new ArrayList<CommandRegistrar>();
    private static CommandDispatcher<class_2168> dispatcher;
    private static boolean initialized;

    public static void register(CommandRegistrar registrar) {
        registrars.add(registrar);
        if (initialized && dispatcher != null) {
            try {
                registrar.register(dispatcher);
            }
            catch (Exception e) {
                logger.error("Failed to register command immediately after registration: {}", e);
            }
        }
    }

    public static void initializeDispatcher(CommandDispatcher<class_2168> dispatcher) {
        EaseonCommand.dispatcher = dispatcher;
        initialized = true;
        for (CommandRegistrar registrar : registrars) {
            try {
                registrar.register(EaseonCommand.dispatcher);
            }
            catch (Exception e) {
                logger.error("Failed to register command during dispatcher initialization: {}", e);
            }
        }
    }

    static {
        initialized = false;
    }

    @FunctionalInterface
    public static interface CommandRegistrar {
        public void register(CommandDispatcher<class_2168> var1);
    }
}

