/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.util.mod;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public final class EaseonModInfo {
    public final String id;
    public final String packageName;
    public final String name;
    public final String version;
    public final String description;

    private EaseonModInfo(String id, String packageName, String name, String version, String description) {
        this.id = id;
        this.packageName = packageName;
        this.name = name;
        this.version = version;
        this.description = description;
    }

    public String toString() {
        return String.format("EaseonModInfo{id='%s', name='%s', version='%s'}", this.id, this.name, this.version);
    }

    public static EaseonModInfo get(Class<?> clazz) {
        String packageName = clazz.getPackageName();
        String modName = EaseonModInfo.extractModName(packageName);
        String modId = EaseonModInfo.buildModId(packageName, modName);
        return EaseonModInfo.createFromContainer(modId, packageName);
    }

    public static EaseonModInfo get(String modId) {
        return EaseonModInfo.createFromContainer(modId, modId);
    }

    private static EaseonModInfo createFromContainer(String modId, String packageName) {
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new RuntimeException("Mod not found: " + modId));
        return new EaseonModInfo(container.getMetadata().getId(), packageName, container.getMetadata().getName(), container.getMetadata().getVersion().getFriendlyString(), container.getMetadata().getDescription());
    }

    private static String extractModName(String packageName) {
        return packageName.replaceFirst("^com\\.([^.]+)\\.([^.]+)\\.([^.]+)(\\..*)?$", "$3");
    }

    private static String buildModId(String packageName, String modName) {
        return String.format("%s-%s-%s", packageName.replaceFirst("^com\\.([^.]+)\\.([^.]+)\\.([^.]+)(\\..*)?$", "$1"), packageName.replaceFirst("^com\\.([^.]+)\\.([^.]+)\\.([^.]+)(\\..*)?$", "$2"), modName);
    }
}

