/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.util.system;

import com.easeon.ss.core.util.mod.EaseonModInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaseonLogger {
    private final Logger LOGGER;

    public EaseonLogger(String modName) {
        this.LOGGER = LoggerFactory.getLogger((String)modName);
    }

    public static EaseonLogger get() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String className = caller.getClassName();
        try {
            Class<?> clazz = Class.forName(className);
            EaseonModInfo info = EaseonModInfo.get(clazz);
            return new EaseonLogger(info.name.replace(" ", "") + "/" + clazz.getSimpleName());
        }
        catch (ClassNotFoundException e) {
            return new EaseonLogger(className.substring(className.lastIndexOf(46) + 1));
        }
    }

    public static EaseonLogger get(Class<?> clazz) {
        EaseonModInfo info = EaseonModInfo.get(clazz);
        return new EaseonLogger(info.name.replace(" ", "") + "/" + clazz.getSimpleName());
    }

    public void info(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.LOGGER.info("{}", (Object)String.format(msg, args));
    }

    public void warn(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.LOGGER.warn("{}", (Object)String.format(msg, args));
    }

    public void error(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.LOGGER.error("{}", (Object)String.format(msg, args));
    }

    public void error(String message, Throwable throwable) {
        this.LOGGER.error("{}", (Object)message, (Object)throwable);
    }

    public void debug(String format, Object ... args) {
        String msg = format.replace("{}", "%s");
        this.LOGGER.debug("{}", (Object)String.format(msg, args));
    }
}

