/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonEntity;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class EaseonEntityInteract {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<EntityInteractTask> _beforeTasks = new CopyOnWriteArrayList<EntityInteractTask>();
    private static final List<EntityInteractTask> _afterTasks = new CopyOnWriteArrayList<EntityInteractTask>();
    private static final Map<Object, EntityInteractTask> _methodRefTasks = new HashMap<Object, EntityInteractTask>();

    public static EntityInteractTask on(EventPhase phase, EntityInteractRunnableWrapper task) {
        EntityInteractTask entityInteractTask = new EntityInteractTask(phase, (player, world, target, hand) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), hand, new EaseonEntity(target)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(entityInteractTask);
        } else {
            _afterTasks.add(entityInteractTask);
        }
        _methodRefTasks.put(task, entityInteractTask);
        return entityInteractTask;
    }

    public static void off(EntityInteractTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static EntityInteractTask register(EntityInteractRunnable task) {
        return EaseonEntityInteract.register(EventPhase.AFTER, task);
    }

    public static EntityInteractTask register(EventPhase phase, EntityInteractRunnable task) {
        EntityInteractTask entityInteractTask = new EntityInteractTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(entityInteractTask);
        } else {
            _afterTasks.add(entityInteractTask);
        }
        _methodRefTasks.put(task, entityInteractTask);
        return entityInteractTask;
    }

    public static void register(EntityInteractTask task) {
        List<EntityInteractTask> targetList;
        List<EntityInteractTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(EntityInteractTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(EntityInteractRunnable task) {
        EntityInteractTask entityInteractTask = _methodRefTasks.remove(task);
        if (entityInteractTask != null) {
            _beforeTasks.remove(entityInteractTask);
            _afterTasks.remove(entityInteractTask);
        }
    }

    public static class_1269 onEntityInteractBefore(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
        return EaseonEntityInteract.executeTasks(_beforeTasks, player, world, target, hand, "BEFORE");
    }

    public static class_1269 onEntityInteractAfter(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
        return EaseonEntityInteract.executeTasks(_afterTasks, player, world, target, hand, "AFTER");
    }

    public static class_1269 onEntityInteract(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
        return EaseonEntityInteract.onEntityInteractAfter(player, world, target, hand);
    }

    private static class_1269 executeTasks(List<EntityInteractTask> tasks, class_3222 player, class_1937 world, class_1297 target, class_1268 hand, String phase) {
        for (EntityInteractTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, target, hand);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in entity interact task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class EntityInteractTask {
        private final EventPhase _phase;
        private final EntityInteractRunnable _task;

        public EntityInteractTask(EventPhase phase, EntityInteractRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public class_1269 execute(class_3222 player, class_1937 world, class_1297 target, class_1268 hand) {
            return this._task.run(player, world, target, hand);
        }
    }

    @FunctionalInterface
    public static interface EntityInteractRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, class_1268 var3, EaseonEntity var4);
    }

    @FunctionalInterface
    public static interface EntityInteractRunnable {
        public class_1269 run(class_3222 var1, class_1937 var2, class_1297 var3, class_1268 var4);
    }
}

