/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonEntity;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_3218;

public class EaseonEntitySpawn {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<EntitySpawnTask> _beforeTasks = new CopyOnWriteArrayList<EntitySpawnTask>();
    private static final List<EntitySpawnTask> _afterTasks = new CopyOnWriteArrayList<EntitySpawnTask>();
    private static final Map<Object, EntitySpawnTask> _methodRefTasks = new HashMap<Object, EntitySpawnTask>();

    public static EntitySpawnTask on(EventPhase phase, EntitySpawnRunnableWrapper task) {
        EntitySpawnTask spawnTask = new EntitySpawnTask(phase, (entity, world) -> task.run(new EaseonWorld(world), new EaseonEntity(entity)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(spawnTask);
        } else {
            _afterTasks.add(spawnTask);
        }
        return spawnTask;
    }

    public static void off(EntitySpawnTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static EntitySpawnTask register(EntitySpawnRunnable task) {
        return EaseonEntitySpawn.register(EventPhase.AFTER, task);
    }

    public static EntitySpawnTask register(EventPhase phase, EntitySpawnRunnable task) {
        EntitySpawnTask spawnTask = new EntitySpawnTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(spawnTask);
        } else {
            _afterTasks.add(spawnTask);
        }
        _methodRefTasks.put(task, spawnTask);
        return spawnTask;
    }

    public static void register(EntitySpawnTask task) {
        List<EntitySpawnTask> targetList;
        List<EntitySpawnTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
        _methodRefTasks.put(task.getTask(), task);
    }

    public static void unregister(EntitySpawnRunnable task) {
        EntitySpawnTask entitySpawnTask = _methodRefTasks.remove(task);
        if (entitySpawnTask != null) {
            _beforeTasks.remove(entitySpawnTask);
            _afterTasks.remove(entitySpawnTask);
        }
    }

    public static void unregister(EntitySpawnTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
        _methodRefTasks.remove(task.getTask());
    }

    public static class_1269 onEntitySpawnBefore(class_1297 entity, class_3218 world) {
        for (EntitySpawnTask task : _beforeTasks) {
            try {
                class_1269 result = task.run(entity, world);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error executing BEFORE EntitySpawn task", e);
            }
        }
        return class_1269.field_5811;
    }

    public static void onEntitySpawnAfter(class_1297 entity, class_3218 world) {
        for (EntitySpawnTask task : _afterTasks) {
            try {
                task.run(entity, world);
            }
            catch (Exception e) {
                logger.error("Error executing AFTER EntitySpawn task", e);
            }
        }
    }

    public static class EntitySpawnTask {
        private final EventPhase phase;
        private final EntitySpawnRunnable task;

        public EntitySpawnTask(EventPhase phase, EntitySpawnRunnable task) {
            this.phase = phase;
            this.task = task;
        }

        public class_1269 run(class_1297 entity, class_3218 world) {
            return this.task.run(entity, world);
        }

        public EventPhase getPhase() {
            return this.phase;
        }

        public EntitySpawnRunnable getTask() {
            return this.task;
        }
    }

    @FunctionalInterface
    public static interface EntitySpawnRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonEntity var2);
    }

    @FunctionalInterface
    public static interface EntitySpawnRunnable {
        public class_1269 run(class_1297 var1, class_3218 var2);
    }
}

