/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.common.base;

import com.easeon.ss.core.api.common.config.EaseonToggleConfig;
import com.easeon.ss.core.api.registry.EaseonCommand;
import com.easeon.ss.core.util.interaction.EaseonMessageFormat;
import com.easeon.ss.core.util.interaction.EaseonMessenger;
import com.easeon.ss.core.util.mod.EaseonModInfo;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public abstract class BaseToggleModule {
    public final EaseonModInfo info = EaseonModInfo.of(this.getClass());
    public final EaseonLogger logger = EaseonLogger.of(this.getClass().getName());
    public final EaseonToggleConfig config;

    protected BaseToggleModule() {
        this.config = new EaseonToggleConfig(this.info.configName);
        this.config.load();
        this.registerToggleCommand();
        this.invokeUpdateTask();
    }

    private void registerToggleCommand() {
        EaseonCommand.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"easeon").requires(source -> source.method_9259(this.config.requiredOpLevel))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.info.commandName).executes(ctx -> EaseonMessenger.to((class_2168)ctx.getSource(), EaseonMessageFormat.toggleStatus(this.info.displayName, this.config.enabled)))).then(class_2170.method_9247((String)"on").executes(ctx -> this.toggle((CommandContext<class_2168>)ctx, true)))).then(class_2170.method_9247((String)"off").executes(ctx -> this.toggle((CommandContext<class_2168>)ctx, false))))));
    }

    private int toggle(CommandContext<class_2168> ctx, boolean enable) {
        if (this.config.enabled == enable) {
            EaseonMessenger.to((class_2168)ctx.getSource(), EaseonMessageFormat.toggleAlready(this.info.displayName, enable));
        } else {
            this.config.toggle(enable);
            EaseonMessenger.toAll((class_2168)ctx.getSource(), EaseonMessageFormat.toggleChanged(this.info.displayName, enable));
            this.invokeUpdateTask();
        }
        return 1;
    }

    private void invokeUpdateTask() {
        try {
            this.getClass().getMethod("updateTask", new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            this.logger.error("Failed to call updateTask", e);
        }
    }
}

