/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonBlockHit;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class EaseonBlockUse {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<BlockUseTask> _beforeTasks = new CopyOnWriteArrayList<BlockUseTask>();
    private static final List<BlockUseTask> _afterTasks = new CopyOnWriteArrayList<BlockUseTask>();
    private static final Map<Object, BlockUseTask> _methodRefTasks = new HashMap<Object, BlockUseTask>();

    public static BlockUseTask on(EventPhase phase, BlockUseRunnableWrapper task) {
        BlockUseTask blockUseTask = new BlockUseTask(phase, (player, world, hand, hit) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), hand, new EaseonBlockHit(hit)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(blockUseTask);
        } else {
            _afterTasks.add(blockUseTask);
        }
        return blockUseTask;
    }

    public static void off(BlockUseTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static BlockUseTask register(BlockUseRunnable task) {
        return EaseonBlockUse.register(EventPhase.AFTER, task);
    }

    public static BlockUseTask register(EventPhase phase, BlockUseRunnable task) {
        BlockUseTask blockUseTask = new BlockUseTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(blockUseTask);
        } else {
            _afterTasks.add(blockUseTask);
        }
        _methodRefTasks.put(task, blockUseTask);
        return blockUseTask;
    }

    public static void register(BlockUseTask task) {
        List<BlockUseTask> targetList;
        List<BlockUseTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(BlockUseTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(BlockUseRunnable task) {
        BlockUseTask blockUseTask = _methodRefTasks.remove(task);
        if (blockUseTask != null) {
            _beforeTasks.remove(blockUseTask);
            _afterTasks.remove(blockUseTask);
        }
    }

    public static class_1269 onBlockUseBefore(class_3222 player, class_1937 world, class_1268 hand, class_3965 hit) {
        return EaseonBlockUse.executeTasks(_beforeTasks, player, world, hand, hit, "BEFORE");
    }

    public static class_1269 onBlockUseAfter(class_3222 player, class_1937 world, class_1268 hand, class_3965 hit) {
        return EaseonBlockUse.executeTasks(_afterTasks, player, world, hand, hit, "AFTER");
    }

    public static class_1269 onBlockUse(class_3222 player, class_1937 world, class_1268 hand, class_3965 hit) {
        return EaseonBlockUse.onBlockUseAfter(player, world, hand, hit);
    }

    private static class_1269 executeTasks(List<BlockUseTask> tasks, class_3222 player, class_1937 world, class_1268 hand, class_3965 hit, String phase) {
        for (BlockUseTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, hand, hit);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in block use task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class BlockUseTask {
        private final EventPhase _phase;
        private final BlockUseRunnable _task;

        public BlockUseTask(EventPhase phase, BlockUseRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public class_1269 execute(class_3222 player, class_1937 world, class_1268 hand, class_3965 hit) {
            return this._task.run(player, world, hand, hit);
        }
    }

    @FunctionalInterface
    public static interface BlockUseRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, class_1268 var3, EaseonBlockHit var4);
    }

    @FunctionalInterface
    public static interface BlockUseRunnable {
        public class_1269 run(class_3222 var1, class_1937 var2, class_1268 var3, class_3965 var4);
    }
}

