/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonDamage;
import com.easeon.ss.core.wrapper.EaseonEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class EaseonEntityDeath {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<DeathTask> _beforeTasks = new CopyOnWriteArrayList<DeathTask>();
    private static final List<DeathTask> _afterTasks = new CopyOnWriteArrayList<DeathTask>();
    private static final Map<Object, DeathTask> _methodRefTasks = new HashMap<Object, DeathTask>();

    public static DeathTask on(EventPhase phase, DeathRunnableWrapper task) {
        DeathTask deathTask = new DeathTask(phase, (entity, source) -> task.run(new EaseonEntity((class_1297)entity), new EaseonDamage(source)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(deathTask);
        } else {
            _afterTasks.add(deathTask);
        }
        return deathTask;
    }

    public static void off(DeathTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static DeathTask register(DeathRunnable task) {
        return EaseonEntityDeath.register(EventPhase.AFTER, task);
    }

    public static DeathTask register(EventPhase phase, DeathRunnable task) {
        DeathTask deathTask = new DeathTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(deathTask);
        } else {
            _afterTasks.add(deathTask);
        }
        _methodRefTasks.put(task, deathTask);
        return deathTask;
    }

    public static void register(DeathTask task) {
        List<DeathTask> targetList;
        List<DeathTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(DeathTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(DeathRunnable task) {
        DeathTask deathTask = _methodRefTasks.remove(task);
        if (deathTask != null) {
            _beforeTasks.remove(deathTask);
            _afterTasks.remove(deathTask);
        }
    }

    public static class_1269 onDeathBefore(class_1309 entity, class_1282 source) {
        return EaseonEntityDeath.executeTasks(_beforeTasks, entity, source, "BEFORE");
    }

    public static class_1269 onDeathAfter(class_1309 entity, class_1282 source) {
        return EaseonEntityDeath.executeTasks(_afterTasks, entity, source, "AFTER");
    }

    public static class_1269 onDeath(class_1309 entity, class_1282 source) {
        return EaseonEntityDeath.onDeathAfter(entity, source);
    }

    private static class_1269 executeTasks(List<DeathTask> tasks, class_1309 entity, class_1282 source, String phase) {
        for (DeathTask task : tasks) {
            try {
                class_1269 result = task.execute(entity, source);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in death task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class DeathTask {
        private final EventPhase _phase;
        private final DeathRunnable _task;

        public DeathTask(EventPhase phase, DeathRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public class_1269 execute(class_1309 entity, class_1282 source) {
            return this._task.run(entity, source);
        }
    }

    @FunctionalInterface
    public static interface DeathRunnableWrapper {
        public class_1269 run(EaseonEntity var1, EaseonDamage var2);
    }

    @FunctionalInterface
    public static interface DeathRunnable {
        public class_1269 run(class_1309 var1, class_1282 var2);
    }
}

