/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class EaseonItemUse {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<ItemUseTask> _beforeTasks = new CopyOnWriteArrayList<ItemUseTask>();
    private static final List<ItemUseTask> _afterTasks = new CopyOnWriteArrayList<ItemUseTask>();
    private static final Map<Object, ItemUseTask> _methodRefTasks = new HashMap<Object, ItemUseTask>();

    public static ItemUseTask on(EventPhase phase, ItemUseRunnableWrapper task) {
        ItemUseTask itemUseTask = new ItemUseTask(phase, (player, world, hand) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), hand));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(itemUseTask);
        } else {
            _afterTasks.add(itemUseTask);
        }
        return itemUseTask;
    }

    public static void off(ItemUseTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static ItemUseTask register(ItemUseRunnable task) {
        return EaseonItemUse.register(EventPhase.AFTER, task);
    }

    public static ItemUseTask register(EventPhase phase, ItemUseRunnable task) {
        ItemUseTask itemUseTask = new ItemUseTask(phase, task);
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(itemUseTask);
        } else {
            _afterTasks.add(itemUseTask);
        }
        _methodRefTasks.put(task, itemUseTask);
        return itemUseTask;
    }

    public static void register(ItemUseTask task) {
        List<ItemUseTask> targetList;
        List<ItemUseTask> list = targetList = task.getPhase() == EventPhase.BEFORE ? _beforeTasks : _afterTasks;
        if (!targetList.contains(task)) {
            targetList.add(task);
        }
    }

    public static void unregister(ItemUseTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static void unregister(ItemUseRunnable task) {
        ItemUseTask itemUseTask = _methodRefTasks.remove(task);
        if (itemUseTask != null) {
            _beforeTasks.remove(itemUseTask);
            _afterTasks.remove(itemUseTask);
        }
    }

    public static class_1269 onItemUseBefore(class_3222 player, class_1937 world, class_1268 hand) {
        return EaseonItemUse.executeTasks(_beforeTasks, player, world, hand, "BEFORE");
    }

    public static class_1269 onItemUseAfter(class_3222 player, class_1937 world, class_1268 hand) {
        return EaseonItemUse.executeTasks(_afterTasks, player, world, hand, "AFTER");
    }

    public static class_1269 onItemUse(class_3222 player, class_1937 world, class_1268 hand) {
        return EaseonItemUse.onItemUseAfter(player, world, hand);
    }

    private static class_1269 executeTasks(List<ItemUseTask> tasks, class_3222 player, class_1937 world, class_1268 hand, String phase) {
        for (ItemUseTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, hand);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in item use task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class ItemUseTask {
        private final EventPhase _phase;
        private final ItemUseRunnable _task;

        public ItemUseTask(EventPhase phase, ItemUseRunnable task) {
            this._phase = phase;
            this._task = task;
        }

        public EventPhase getPhase() {
            return this._phase;
        }

        public class_1269 execute(class_3222 player, class_1937 world, class_1268 hand) {
            return this._task.run(player, world, hand);
        }
    }

    @FunctionalInterface
    public static interface ItemUseRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, class_1268 var3);
    }

    @FunctionalInterface
    public static interface ItemUseRunnable {
        public class_1269 run(class_3222 var1, class_1937 var2, class_1268 var3);
    }
}

