/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.common.base;

import com.easeon.ss.core.api.common.config.EaseonValueConfig;
import com.easeon.ss.core.api.registry.EaseonCommand;
import com.easeon.ss.core.util.interaction.EaseonMessageFormat;
import com.easeon.ss.core.util.interaction.EaseonMessenger;
import com.easeon.ss.core.util.mod.EaseonModInfo;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public abstract class BaseValueModule {
    public final EaseonModInfo info = EaseonModInfo.of(this.getClass());
    public final EaseonLogger logger = EaseonLogger.of(this.getClass().getName());
    public final EaseonValueConfig config;
    private final int minValue;
    private final int maxValue;

    protected BaseValueModule(int defaultValue, int minValue, int maxValue) {
        this(defaultValue, minValue, maxValue, true);
    }

    protected BaseValueModule(int defaultValue, int minValue, int maxValue, boolean command) {
        this.config = new EaseonValueConfig(this.info.configName, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.config.load();
        if (command) {
            this.registerToggleCommand();
            this.invokeUpdateTask();
        }
    }

    private void registerToggleCommand() {
        EaseonCommand.register(dispatcher -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"easeon").requires(source -> source.method_9259(this.config.requiredOpLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)this.info.commandName).executes(ctx -> EaseonMessenger.to((class_2168)ctx.getSource(), EaseonMessageFormat.valueStatus(this.info.displayName, this.config.value)))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)this.minValue, (int)this.maxValue)).executes(this::setValue)))));
    }

    private int setValue(CommandContext<class_2168> ctx) {
        int oldValue = this.config.value;
        int newValue = IntegerArgumentType.getInteger(ctx, (String)"value");
        if (oldValue == newValue) {
            EaseonMessenger.to((class_2168)ctx.getSource(), EaseonMessageFormat.valueAlready(this.info.displayName, newValue));
        } else {
            this.config.setValue(newValue);
            this.invokeUpdateTask();
            EaseonMessenger.toAll((class_2168)ctx.getSource(), EaseonMessageFormat.valueChanged(this.info.displayName, oldValue, newValue));
        }
        return 1;
    }

    private void invokeUpdateTask() {
        try {
            this.getClass().getMethod("updateTask", new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            this.logger.error("Failed to call updateTask", e);
        }
    }
}

