/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.common.config;

import com.easeon.ss.core.api.common.config.EaseonConfig;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public class EaseonValueConfig
extends EaseonConfig {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static String CONFIG_PATH;
    public int value = 2;
    public int requiredOpLevel = 2;

    public EaseonValueConfig(String configName, int defaultValue) {
        this.configPath = String.format("config/easeon/%s.json", configName);
        this.value = defaultValue;
    }

    @Override
    public void load() {
        File configFile = new File(this.configPath);
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            EaseonValueConfig loaded;
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (String oldField : new String[]{"dropMultiplier", "xpMultiplier", "pickupRadius"}) {
                if (!json.has(oldField)) continue;
                json.addProperty("value", (Number)json.get(oldField).getAsInt());
                break;
            }
            if ((loaded = (EaseonValueConfig)GSON.fromJson((JsonElement)json, this.getClass())) != null) {
                this.copyFields(loaded);
            }
        }
        catch (Exception e) {
            logger.error("Failed to load config: {}", e);
        }
    }

    public void setValue(int value) {
        this.value = value;
        this.save();
    }
}

