/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.api.definitions.interfaces.EventTask;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonItem;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class EaseonFoodConsume {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<FoodConsumeTask> _beforeTasks = new CopyOnWriteArrayList<FoodConsumeTask>();
    private static final List<FoodConsumeTask> _afterTasks = new CopyOnWriteArrayList<FoodConsumeTask>();

    public static FoodConsumeTask on(EventPhase phase, FoodConsumeRunnableWrapper task) {
        FoodConsumeTask foodConsumeTask = new FoodConsumeTask((player, world, itemStack) -> task.run(new EaseonWorld(world), new EaseonPlayer((class_3222)player), new EaseonItem(itemStack)));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(foodConsumeTask);
        } else {
            _afterTasks.add(foodConsumeTask);
        }
        return foodConsumeTask;
    }

    public static void off(FoodConsumeTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static class_1269 onFoodConsumeBefore(class_1309 player, class_1937 world, class_1799 itemStack) {
        return EaseonFoodConsume.executeTasks(_beforeTasks, player, world, itemStack, "BEFORE");
    }

    public static class_1269 onFoodConsumeAfter(class_1309 player, class_1937 world, class_1799 itemStack) {
        return EaseonFoodConsume.executeTasks(_afterTasks, player, world, itemStack, "AFTER");
    }

    private static class_1269 executeTasks(List<FoodConsumeTask> tasks, class_1309 player, class_1937 world, class_1799 itemStack, String phase) {
        for (FoodConsumeTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, itemStack);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in food consume task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class FoodConsumeTask
    implements EventTask {
        private final FoodConsumeRunnable _task;

        public FoodConsumeTask(FoodConsumeRunnable task) {
            this._task = task;
        }

        public class_1269 execute(class_1309 player, class_1937 world, class_1799 itemStack) {
            return this._task.run(player, world, itemStack);
        }

        @Override
        public EventTask remove() {
            EaseonFoodConsume.off(this);
            return null;
        }
    }

    @FunctionalInterface
    public static interface FoodConsumeRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, EaseonItem var3);
    }

    @FunctionalInterface
    public static interface FoodConsumeRunnable {
        public class_1269 run(class_1309 var1, class_1937 var2, class_1799 var3);
    }
}

