/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.api.events;

import com.easeon.ss.core.api.definitions.enums.EventPhase;
import com.easeon.ss.core.api.definitions.interfaces.EventTask;
import com.easeon.ss.core.util.system.EaseonLogger;
import com.easeon.ss.core.wrapper.EaseonItem;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import com.easeon.ss.core.wrapper.EaseonWorld;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class EaseonItemUse {
    private static final EaseonLogger logger = EaseonLogger.of();
    private static final List<ItemUseTask> _beforeTasks = new CopyOnWriteArrayList<ItemUseTask>();
    private static final List<ItemUseTask> _afterTasks = new CopyOnWriteArrayList<ItemUseTask>();

    public static ItemUseTask on(EventPhase phase, ItemUseRunnableWrapper task) {
        ItemUseTask itemUseTask = new ItemUseTask((player, world, stack, hand) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), hand));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(itemUseTask);
        } else {
            _afterTasks.add(itemUseTask);
        }
        return itemUseTask;
    }

    public static ItemUseTask on(EventPhase phase, ItemUseRunnableWrapperWithStack task) {
        ItemUseTask itemUseTask = new ItemUseTask((player, world, stack, hand) -> task.run(new EaseonWorld(world), new EaseonPlayer(player), new EaseonItem(stack), hand));
        if (phase == EventPhase.BEFORE) {
            _beforeTasks.add(itemUseTask);
        } else {
            _afterTasks.add(itemUseTask);
        }
        return itemUseTask;
    }

    public static void off(ItemUseTask task) {
        _beforeTasks.remove(task);
        _afterTasks.remove(task);
    }

    public static class_1269 onItemUseBefore(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand) {
        return EaseonItemUse.executeTasks(_beforeTasks, player, world, stack, hand, "BEFORE");
    }

    public static class_1269 onItemUseAfter(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand) {
        return EaseonItemUse.executeTasks(_afterTasks, player, world, stack, hand, "AFTER");
    }

    public static class_1269 onItemUse(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand) {
        return EaseonItemUse.onItemUseAfter(player, world, stack, hand);
    }

    private static class_1269 executeTasks(List<ItemUseTask> tasks, class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, String phase) {
        for (ItemUseTask task : tasks) {
            try {
                class_1269 result = task.execute(player, world, stack, hand);
                if (result == class_1269.field_5811) continue;
                return result;
            }
            catch (Exception e) {
                logger.error("Error in item use task ({}): {}", phase, e);
            }
        }
        return class_1269.field_5811;
    }

    public static class ItemUseTask
    implements EventTask {
        private final ItemUseRunnable _task;

        public ItemUseTask(ItemUseRunnable task) {
            this._task = task;
        }

        public class_1269 execute(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand) {
            return this._task.run(player, world, stack, hand);
        }

        @Override
        public EventTask remove() {
            EaseonItemUse.off(this);
            return null;
        }
    }

    @FunctionalInterface
    public static interface ItemUseRunnableWrapper {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, class_1268 var3);
    }

    @FunctionalInterface
    public static interface ItemUseRunnable {
        public class_1269 run(class_3222 var1, class_1937 var2, class_1799 var3, class_1268 var4);
    }

    @FunctionalInterface
    public static interface ItemUseRunnableWrapperWithStack {
        public class_1269 run(EaseonWorld var1, EaseonPlayer var2, EaseonItem var3, class_1268 var4);
    }
}

