/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.core.wrapper;

import com.easeon.ss.core.wrapper.EaseonBlock;
import com.easeon.ss.core.wrapper.EaseonItem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class EaseonWorld {
    private final class_3218 world;
    private final class_1937 clientWorld;
    public final boolean isServer;

    public EaseonWorld(class_3218 world) {
        this.world = world;
        this.clientWorld = null;
        this.isServer = true;
    }

    public EaseonWorld(class_1937 world) {
        if (world instanceof class_3218) {
            this.world = (class_3218)world;
            this.clientWorld = null;
            this.isServer = true;
        } else {
            this.world = null;
            this.clientWorld = world;
            this.isServer = false;
        }
    }

    public class_1937 get() {
        return this.isServer ? this.world : this.clientWorld;
    }

    public class_3218 getServerWorld() {
        return this.world;
    }

    public EaseonBlock getBlockState(class_2338 pos) {
        return this.executeGet(w -> new EaseonBlock(w.method_8320(pos)));
    }

    public class_2586 getBlockEntity(class_2338 pos) {
        return this.executeGet(w -> w.method_8321(pos));
    }

    public <T extends class_1297> List<T> getEntitiesByClass(Class<T> entityClass, class_238 box, Predicate<? super T> predicate) {
        return this.executeGet(w -> w.method_8390(entityClass, box, predicate));
    }

    public boolean isClient() {
        return !this.isServer;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public void dropItem(class_2338 pos, class_1792 item, int count) {
        this.dropItem(pos, new EaseonItem(item), count);
    }

    public void dropItem(class_2338 pos, EaseonBlock item, int count) {
        this.dropItem(pos, item.easeonItem(), count);
    }

    public void dropItem(class_2338 pos, EaseonItem item, int count) {
        class_1799 stack = new class_1799((class_1935)item.getItem(), count);
        this.execute(w -> class_2248.method_9577((class_1937)w, (class_2338)pos, (class_1799)stack));
    }

    public <T extends class_2394> void particles(T type, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        class_3218 class_32182 = this.world;
        if (class_32182 instanceof class_3218) {
            class_3218 serverWorld = class_32182;
            serverWorld.method_65096(type, x, y, z, count, offsetX, offsetY, offsetZ, speed);
        }
    }

    public void playSound(class_243 pos, class_3414 sound, class_3419 category, float volume) {
        this.execute(w -> w.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, sound, category, volume, 1.0f));
    }

    public void setBlockState(class_2338 pos, class_2680 block) {
        this.execute(w -> w.method_8501(pos, block));
    }

    public void spawnExperienceOrb(class_243 pos, int amount) {
        class_3218 class_32182 = this.world;
        if (class_32182 instanceof class_3218) {
            class_3218 serverWorld = class_32182;
            class_1303.method_31493((class_3218)serverWorld, (class_243)pos, (int)amount);
        }
    }

    private void execute(Consumer<class_1937> action) {
        Stream.of(this.world, this.clientWorld).filter(Objects::nonNull).findFirst().ifPresent(action);
    }

    private <R> R executeGet(Function<class_1937, R> action) {
        return Stream.of(this.world, this.clientWorld).filter(Objects::nonNull).findFirst().map(action).orElse(null);
    }
}

