package net.inventive_mods.inventive_inventory.config.enums.automatic_refilling;

import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.accessors.Translatable;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public enum ToolReplacementBehaviour implements Translatable {
    KEEP_TOOL("keep_tool"),
    BREAK_TOOL("break_tool");

    private final String translationKey;

    ToolReplacementBehaviour(String translationKey) {
        this.translationKey = "automatic_refilling.tool_replacement_behaviour." + translationKey;
    }

    public static boolean isValid(class_1799 stack) {
        return ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(KEEP_TOOL) && stack.method_7936() - stack.method_7919() == 2 ||
                stack.method_7936() - stack.method_7919() == 1;
    }

    @Override
    public class_2561 getButtonText() {
        return class_2561.method_43471(ConfigManager.OPTION_TRANSLATION_KEY + "." + this.translationKey);
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }
}
