package net.inventive_mods.inventive_inventory.config.screens.widgets;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.options.fields.ColorFieldOption;
import net.inventive_mods.inventive_inventory.util.widgets.CustomClickableWidget;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5253;
import net.minecraft.class_7919;
import net.minecraft.class_8667;
import java.util.concurrent.atomic.AtomicBoolean;

public class ColorPickerWidget extends CustomClickableWidget {
    private final class_8667 vertical = class_8667.method_52741().method_52735(5);

    public ColorPickerWidget(ColorFieldOption option) {
        super(150, 45);
        ColorFieldWidget colorField = new ColorFieldWidget(class_2561.method_30163(Integer.toHexString(option.getValue() & 0xFFFFFF)), option);
        ConfigSliderWidget sliderWidget = new ConfigSliderWidget(150, 20, (double) class_5253.class_5254.method_27762(option.getValue()) / 255, option);
        class_8667 horizontal = class_8667.method_52742().method_52735(50);
        horizontal.method_52736(colorField);
        horizontal.method_52736(
                class_4185.method_46430(class_2561.method_43471("config.visuals.button.text.inventive_inventory.locked_slots.color.reset"),
                        button -> {
                            colorField.reset();
                            sliderWidget.reset();
                            super.method_25354(InventiveInventory.getClient().method_1483());
                        })
                .method_46436(class_7919.method_47407(class_2561.method_43471("config.visuals.button.tooltip.inventive_inventory.locked_slots.color.reset")))
                .method_46437(50, 20)
                .method_46431()
        );
        this.vertical.method_52736(horizontal);
        this.vertical.method_52736(sliderWidget);
        this.vertical.method_48222();
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.vertical.method_48229(this.method_46426(), this.method_46427());
        this.vertical.method_48227(widget -> {
            if (widget instanceof class_339) ((class_339) widget).method_25394(context, mouseX, mouseY, delta);
            else if (widget instanceof class_8667) widget.method_48206(innerWidget -> innerWidget.method_25394(context, mouseX, mouseY, delta));
        });
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.vertical.method_48227(element -> {
            if (element instanceof ConfigSliderWidget sliderWidget) {
                if (mouseX >= sliderWidget.method_46426() && mouseX <= sliderWidget.method_55442() && mouseY >= sliderWidget.method_46427() && mouseY <= sliderWidget.method_55443()) {
                    sliderWidget.method_25348(mouseX, mouseY);
                }
            } else if (element instanceof class_8667 layoutWidget) {
                layoutWidget.method_48227(innerElement -> {
                    if (innerElement instanceof class_342 textFieldWidget) {
                        if (mouseX >= textFieldWidget.method_46426() && mouseX <= textFieldWidget.method_55442() && mouseY >= textFieldWidget.method_46427() && mouseY <= textFieldWidget.method_55443()) {
                            textFieldWidget.method_25365(true);
                            textFieldWidget.method_25348(mouseX, mouseY);
                        } else textFieldWidget.method_25365(false);
                    } else if (innerElement instanceof class_339 clickableWidget) {
                        if (mouseX >= clickableWidget.method_46426() && mouseX <= clickableWidget.method_55442() && mouseY >= clickableWidget.method_46427() && mouseY <= clickableWidget.method_55443()) {
                            clickableWidget.method_25348(mouseX, mouseY);
                        }
                    }
                });
            }
        });
    }

    @Override
    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.vertical.method_48227(element -> {
            if (element instanceof ConfigSliderWidget sliderWidget) {
                if (mouseX >= sliderWidget.method_46426() && mouseX <= sliderWidget.method_55442() && mouseY >= sliderWidget.method_46427() && mouseY <= sliderWidget.method_55443()) {
                    sliderWidget.method_25349(mouseX, mouseY, deltaX, deltaY);
                }
            }
        });
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.vertical.method_48227(element -> {
           if (element instanceof class_8667 layoutWidget) {
                layoutWidget.method_48227(innerElement -> {
                    if (innerElement instanceof class_342 textFieldWidget) {
                        textFieldWidget.method_25404(keyCode, scanCode, modifiers);
                    }
                });
            }
        });
        return false;
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        this.vertical.method_48227(element -> {
            if (element instanceof class_8667 layoutWidget) {
                layoutWidget.method_48227(innerElement -> {
                    if (innerElement instanceof class_342 textFieldWidget) {
                        textFieldWidget.method_25400(chr, modifiers);
                    }
                });
            }
        });
        return false;
    }

    @Override
    public void method_25354(class_1144 soundManager) {}

    public boolean overSliderWidget(double mouseX, double mouseY) {
        AtomicBoolean bl = new AtomicBoolean(false);
        this.vertical.method_48227(element -> {
            if (element instanceof ConfigSliderWidget sliderWidget) {
                bl.set(mouseX >= sliderWidget.method_46426() && mouseX <= sliderWidget.method_55442() && mouseY >= sliderWidget.method_46427() && mouseY <= sliderWidget.method_55443());
            }
        });
        return bl.get();
    }

    public void clickSliderWidget(double mouseX, double mouseY) {
        this.vertical.method_48227(element -> {
            if (element instanceof ConfigSliderWidget sliderWidget) {
                sliderWidget.method_25348(mouseX, mouseY);
            }
        });
    }

    public void dragSliderWidget(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.vertical.method_48227(element -> {
            if (element instanceof ConfigSliderWidget sliderWidget) {
                sliderWidget.method_25349(mouseX, mouseY, deltaX, deltaY);
            }
        });
    }
}
