package net.inventive_mods.inventive_inventory.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.features.profiles.SavedSlot;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

public class Converter {
    public static JsonObject itemStackToJson(class_1799 stack) {
        JsonObject stackJson = new JsonObject();
        if (stack == null) return stackJson;
        stackJson.addProperty("id", class_1792.method_7880(stack.method_7909()));

        JsonObject componentsJson = new JsonObject();
        class_2561 customName = stack.method_57824(class_9334.field_49631);
        if (customName != null) componentsJson.addProperty("custom_name", customName.getString());

        class_9304 enchantmentsComponent = stack.method_57824(class_9334.field_49633);
        if (enchantmentsComponent != null && !enchantmentsComponent.method_57543()) {
            JsonArray enchantmentsList = new JsonArray();
            class_2378<class_1887> enchantmentRegistry = InventiveInventory.getRegistryManager().method_30530(class_7924.field_41265);
            for (class_6880<class_1887> enchantmentRegistryEntry : enchantmentsComponent.method_57534().stream().toList()) {
                JsonObject enchantmentComponent = new JsonObject();
                class_1887 enchantment = enchantmentRegistry.method_10223(new class_2960(enchantmentRegistryEntry.method_55840()));
                enchantmentComponent.addProperty("id", enchantmentRegistryEntry.method_55840());
                enchantmentComponent.addProperty("lvl", enchantmentsComponent.method_57536(enchantment));
                enchantmentsList.add(enchantmentComponent);
            }
            componentsJson.add("enchantments", enchantmentsList);
        }

        class_1844 potionComponent = stack.method_57824(class_9334.field_49651);
        if (potionComponent != null && potionComponent.comp_2378().isPresent()) {
            componentsJson.addProperty("potion", potionComponent.comp_2378().get().method_55840());
        }

        stackJson.add("components", componentsJson);
        return stackJson;
    }

    public static class_1799 jsonToItemStack(JsonObject stackJson) {
        if (stackJson.get("id") == null) return null;
        class_1799 item = new class_1799(class_6880.method_40223(class_1792.method_7875(stackJson.get("id").getAsInt())));
        class_9323.class_9324 componentBuilder = class_9323.method_57827();

        if (stackJson.getAsJsonObject("components").has("custom_name")) {
            componentBuilder.method_57840(class_9334.field_49631, class_2561.method_30163(stackJson.getAsJsonObject("components").get("custom_name").getAsString()));
        }

        if (stackJson.getAsJsonObject("components").has("enchantments")) {
            class_9304.class_9305 enchantmentBuilder = new class_9304.class_9305(class_9304.field_49385);
            class_2378<class_1887> enchantmentRegistry = InventiveInventory.getRegistryManager().method_30530(class_7924.field_41265);
            for (JsonElement enchantmentElement : stackJson.getAsJsonObject("components").get("enchantments").getAsJsonArray()) {
                JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                class_1887 enchantment = enchantmentRegistry.method_10223(new class_2960(enchantmentObject.get("id").getAsString()));
                enchantmentBuilder.method_57550(enchantment, enchantmentObject.get("lvl").getAsInt());
            }
            componentBuilder.method_57840(class_9334.field_49633, enchantmentBuilder.method_57549());
        }

        if (stackJson.getAsJsonObject("components").has("potion")) {
            class_2378<class_1842> potionRegistry = InventiveInventory.getRegistryManager().method_30530(class_7924.field_41215);
            class_1842 potion = potionRegistry.method_10223(new class_2960(stackJson.getAsJsonObject("components").get("potion").getAsString()));
            item = class_1844.method_57400(class_1802.field_8574, potionRegistry.method_47983(potion));
        }

        item.method_57365(componentBuilder.method_57838());
        return item;
    }

    public static List<SavedSlot> jsonToSavedSlots(JsonArray savedSlotsJson) {
        List<SavedSlot> savedSlotList = new ArrayList<>();
        for (JsonElement savedSlotElement : savedSlotsJson) {
            JsonObject savedSlotObject = savedSlotElement.getAsJsonObject();
            int slot = savedSlotObject.get("slot").getAsInt();
            class_1799 stack = Converter.jsonToItemStack(savedSlotObject.getAsJsonObject("stack"));
            savedSlotList.add(new SavedSlot(slot, stack));
        }
        return savedSlotList;
    }
}
