package net.inventive_mods.inventive_inventory.util;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_636;
import net.minecraft.class_746;

public class InteractionHandler {
    private static final int LEFT_CLICK = 0;
    private static final int RIGHT_CLICK = 1;

    public static class_1799 getCursorStack() {
        return InventiveInventory.getScreenHandler().method_34255();
    }

    public static boolean isCursorFull() {
        return !getCursorStack().method_7960();
    }

    public static class_1799 getStackFromSlot(int slot) {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        return screenHandler.method_7611(slot).method_7677();
    }

    public static int getSelectedSlot() {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        class_746 player = InventiveInventory.getPlayer();
        return screenHandler.method_37418(player.method_31548(), player.method_31548().field_7545).orElse(-1);
    }

    public static void setSelectedSlot(int slot) {
        InventiveInventory.getPlayer().method_31548().field_7545 = slot;
    }

    public static class_1799 getMainHandStack() {
        return InventiveInventory.getPlayer().method_6047();
    }

    public static class_1799 getOffHandStack() {
        return InventiveInventory.getPlayer().method_6079();
    }

    public static class_1799 getAnyHandStack() {
        if (!class_1799.method_7984(getMainHandStack(), class_1799.field_8037)) return getMainHandStack();
        else if (!class_1799.method_7984(getOffHandStack(), class_1799.field_8037)) return getOffHandStack();
        else return class_1799.field_8037;
    }

    public static void leftClickStack(int slot) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        manager.method_2906(getSyncId(), slot, LEFT_CLICK, class_1713.field_7790, player);
    }

    public static void rightClickStack(int slot) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        manager.method_2906(getSyncId(), slot, RIGHT_CLICK, class_1713.field_7790, player);
    }

    public static void swapStacks(int slot, int target) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        manager.method_2906(getSyncId(), slot, LEFT_CLICK, class_1713.field_7790, player);
        manager.method_2906(getSyncId(), target, LEFT_CLICK, class_1713.field_7790, player);
        if (isCursorFull()) {
            manager.method_2906(getSyncId(), slot, LEFT_CLICK, class_1713.field_7790, player);
        }
    }

    public static void dropItem(int slot, int times) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        if (isCursorFull()) {
            leftClickStack(slot);
            dropCursor(times);
            leftClickStack(slot);
        } else for (; times > 0; times--) manager.method_2906(getSyncId(), slot, LEFT_CLICK, class_1713.field_7795, player);
    }

    public static void dropCursor(int times) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        for (; times > 0; times--) manager.method_2906(getSyncId(), class_1703.field_30730, RIGHT_CLICK, class_1713.field_7790, player);
    }

    public static void quickMove(int slot) {
        class_636 manager = InventiveInventory.getInteractionManager();
        class_746 player = InventiveInventory.getPlayer();
        manager.method_2906(getSyncId(), slot, LEFT_CLICK, class_1713.field_7794, player);
    }

    private static int getSyncId() {
        return InventiveInventory.getScreenHandler().field_7763;
    }
}
