/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.util.tooltips;

import java.util.ArrayList;
import java.util.List;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.util.tooltips.TooltipType;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TooltipBuilder {
    private static final String TOOLTIP_TRANSLATION_KEY = "profiles.screen.tooltip.inventive_inventory.";

    public static List<class_2561> of(TooltipType type, Profile profile) {
        if (type == TooltipType.NAME) {
            return TooltipBuilder.buildName(profile);
        }
        if (type == TooltipType.ITEM) {
            return TooltipBuilder.buildItem(profile);
        }
        if (type == TooltipType.UNKNOWN) {
            return TooltipBuilder.buildUnknown(profile);
        }
        if (type == TooltipType.PLUS) {
            return TooltipBuilder.buildPlus();
        }
        return new ArrayList<class_2561>();
    }

    private static List<class_2561> buildName(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle(class_2561.method_30163((String)profile.getName()), class_124.field_1065, textList);
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildItem(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle(class_2561.method_30163((String)profile.getDisplayStack().method_7964().getString()), class_124.field_1075, textList);
        if (profile.getDisplayStack().method_7942()) {
            for (class_6880 entry : profile.getDisplayStack().method_58657().method_57534()) {
                class_1887 enchantment;
                if (!entry.method_40230().isPresent() || (enchantment = (class_1887)class_7923.field_41176.method_29107((class_5321)entry.method_40230().get())) == null) continue;
                textList.add(enchantment.method_8179(class_1890.method_8225((class_1887)enchantment, (class_1799)profile.getDisplayStack())));
            }
            textList.add((class_2561)class_2561.method_43473());
        }
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildUnknown(Profile profile) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        TooltipBuilder.addTitle((class_2561)class_2561.method_43471((String)"profiles.screen.tooltip.inventive_inventory.unnamed"), class_124.field_1080, textList);
        TooltipBuilder.addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildPlus() {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        textList.add((class_2561)class_2561.method_43471((String)"profiles.screen.tooltip.inventive_inventory.plus.1"));
        textList.add((class_2561)class_2561.method_43473());
        textList.add((class_2561)class_2561.method_43471((String)"profiles.screen.tooltip.inventive_inventory.plus.2"));
        return textList;
    }

    private static void addTitle(class_2561 title, class_124 formatting, List<class_2561> textList) {
        textList.add((class_2561)title.method_27661().method_10862(class_2583.field_24360.method_10977(formatting)));
    }

    private static void addKey(Profile profile, List<class_2561> textList) {
        class_304 keyBinding;
        if (profile.getKey() != null && (keyBinding = KeyRegistry.getByTranslationKey(profile.getKey())) != null) {
            textList.add(class_2561.method_30163((String)(class_2561.method_43471((String)"profiles.screen.tooltip.inventive_inventory.key").getString() + ": " + keyBinding.method_16007().getString())));
        }
    }
}

