package net.inventive_mods.inventive_inventory.events;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.Status;
import net.inventive_mods.inventive_inventory.config.enums.automatic_refilling.AutomaticRefillingMode;
import net.inventive_mods.inventive_inventory.context.ContextManager;
import net.inventive_mods.inventive_inventory.context.Contexts;
import net.inventive_mods.inventive_inventory.features.automatic_refilling.AutomaticRefillingHandler;
import net.inventive_mods.inventive_inventory.features.locked_slots.LockedSlotsHandler;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.ProfileHandler;
import net.inventive_mods.inventive_inventory.features.profiles.gui.ProfilesScreen;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.keys.handler.AdvancedOperationHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.minecraft.class_304;
import net.minecraft.class_310;
import java.util.List;

public class TickEvents {

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            TickEvents.playerHandling(client);
            TickEvents.checkKeys(client);
            TickEvents.adjustInventory(client);
            TickEvents.automaticRefilling(client);
        });

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            TickEvents.automaticRefilling(client);
            TickEvents.captureInventory(client);
            TickEvents.loadProfile(client);
        });
    }

    private static void playerHandling(class_310 client) {
        if (client.field_1724 == null) {
            LockedSlotsHandler.reset();
            LockedSlotsHandler.schedulerStarted = false;
            return;
        }
        if (!LockedSlotsHandler.schedulerStarted) LockedSlotsHandler.startScheduler();
        else if (LockedSlotsHandler.shouldInit) LockedSlotsHandler.init();
    }


    private static void checkKeys(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) return;
        if (client.field_1755 == null) {
            AdvancedOperationHandler.setPressed(KeyRegistry.advancedOperationKey.method_1434());
        }
        if (AutomaticRefillingHandler.getSelectedSlot() != InteractionHandler.getSelectedSlot()) {
            AutomaticRefillingHandler.reset();
        }
        if (KeyRegistry.openProfilesScreenKey.method_1434() && ConfigManager.PROFILES_STATUS.is(Status.ENABLED)) {
            client.method_1507(new ProfilesScreen());
        }
    }

    private static void adjustInventory(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) return;
        if (ContextManager.isInit()) LockedSlotsHandler.adjustInventory();
    }

    private static void automaticRefilling(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) return;
        if (AutomaticRefillingMode.isValid() && ConfigManager.AUTOMATIC_REFILLING_STATUS.is(Status.ENABLED) && ContextManager.isInit() && AutomaticRefillingHandler.shouldRun()) {
            ContextManager.setContext(Contexts.AUTOMATIC_REFILLING);
            AutomaticRefillingHandler.runMainHand();
            ContextManager.setContext(Contexts.INIT);
        }
        if (AutomaticRefillingMode.isValid() && ConfigManager.AUTOMATIC_REFILLING_STATUS.is(Status.ENABLED) && ContextManager.isInit() && AutomaticRefillingHandler.shouldRunOffHand()) {
            ContextManager.setContext(Contexts.AUTOMATIC_REFILLING);
            AutomaticRefillingHandler.runOffHand();
            ContextManager.setContext(Contexts.INIT);
        }
    }

    private static void captureInventory(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) return;
        LockedSlotsHandler.setSavedInventory();
        LockedSlotsHandler.setSavedHandlerInventory();
        AutomaticRefillingHandler.setMainHandStack(client.field_1724.method_6047());
        AutomaticRefillingHandler.setOffHandStack(client.field_1724.method_6079());
        AutomaticRefillingHandler.setSelectedSlot(InteractionHandler.getSelectedSlot());
    }

    private static void loadProfile(class_310 client) {
        if (client.field_1724 == null || client.field_1724.method_7337()) return;
        for (class_304 profileKey : KeyRegistry.profileKeys) {
            if (profileKey.method_1434()) {
                boolean validMode = ConfigManager.FAST_LOAD.is(true) || (ConfigManager.FAST_LOAD.is(false) && KeyRegistry.loadProfileKey.method_1434());
                if (validMode && ContextManager.isInit()) {
                    ContextManager.setContext(Contexts.PROFILES);
                    List<Profile> profiles = ProfileHandler.getProfiles();
                    profiles.forEach(profile -> {
                        if (profileKey.method_1431().equals(profile.getKey())) ProfileHandler.load(profile);
                    });
                    ContextManager.setContext(Contexts.INIT);
                }
            }
        }
    }
}
