package net.inventive_mods.inventive_inventory.features.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.Status;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.util.ComponentsHelper;
import net.inventive_mods.inventive_inventory.util.FileHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.Notifier;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotRange;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProfileHandler {
    private final static String NOTIFICATION_TRANSLATION_KEY = "notification.profiles.inventive_inventory.";
    public static final int MAX_PROFILES = 5;
    private static final String PROFILES_FILE = "profiles.json";
    public static final Path PROFILES_PATH = ConfigManager.CONFIG_PATH.resolve(PROFILES_FILE);
    private static final List<Profile> profiles = new ArrayList<>();

    public static void create(String name, String key) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) return;
        Profile profile = new Profile(profiles.size(), name, key, createSavedSlots());
        if (profiles.size() < MAX_PROFILES) {
            profiles.add(profile);
            save();
            Notifier.send(class_2561.method_43471(NOTIFICATION_TRANSLATION_KEY + "created").getString(), class_124.field_1060);
            return;
        }
        Notifier.error(class_2561.method_43471("error.profiles.inventive_inventory.max_amount").getString());
    }

    public static void load(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) return;
        SlotRange slotRange = PlayerSlots.get(SlotTypes.INVENTORY, SlotTypes.HOTBAR, SlotTypes.OFFHAND);
        slotRange = ConfigManager.PROFILES_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        for (SavedSlot savedSlot : profile.getSavedSlots()) {
            for (int slot : slotRange) {
                class_1799 slotStack = InteractionHandler.getStackFromSlot(slot);
                if (!class_1799.method_7984(slotStack, savedSlot.stack())) continue;
                if (!ComponentsHelper.areCustomNamesEqual(slotStack, savedSlot.stack())) continue;
                if (!ComponentsHelper.areEnchantmentsEqual(slotStack, savedSlot.stack())) continue;
                if (!ComponentsHelper.arePotionsEqual(slotStack, savedSlot.stack())) continue;
                InteractionHandler.swapStacks(slot, savedSlot.slot());
                break;
            }
        }
        Notifier.send(class_2561.method_43471(NOTIFICATION_TRANSLATION_KEY + "loaded").getString(), class_124.field_1078);
    }

    public static void overwrite(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) return;
        Profile newProfile = new Profile(profile.getId(), profile.getName(), profile.getKey(), createSavedSlots());
        profiles.set(profile.getId(), newProfile);
        save();
        Notifier.send(class_2561.method_43471(NOTIFICATION_TRANSLATION_KEY + "overwritten").getString(), class_124.field_1065);
    }

    public static void update(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) return;
        Profile newProfile = new Profile(profile.getId(), profile.getName(), profile.getKey(), profile.getSavedSlots(), profile.getDisplayStack());
        profiles.set(profile.getId(), newProfile);
        save();
        Notifier.send(class_2561.method_43471(NOTIFICATION_TRANSLATION_KEY + "updated").getString(), class_124.field_1065);
    }

    public static void delete(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) return;
        profiles.remove(profile.getId());
        for (int i = 0; i < profiles.size(); i++) {
            profiles.get(i).setId(i);
        }
        save();
        Notifier.send(class_2561.method_43471(NOTIFICATION_TRANSLATION_KEY + "deleted").getString(), class_124.field_1061);
    }

    public static List<Profile> getProfiles() {
        return profiles;
    }

    public static boolean isNoProfile(String name) {
        for (Profile profile : profiles) {
            if (profile.getName().equals(name)) return false;
        }
        return true;
    }

    public static String getAvailableProfileKey() {
        List<class_304> availableProfileKeys = getAvailableProfileKeys();
        if (availableProfileKeys.isEmpty()) return "";
        else return availableProfileKeys.get(0).method_1431();
    }

    public static List<class_304> getAvailableProfileKeys() {
        List<class_304> availableProfileKeys = new ArrayList<>(Arrays.asList(KeyRegistry.profileKeys));
        for (Profile profile : profiles) {
            for (class_304 profileKey : KeyRegistry.profileKeys) {
                if (profileKey.method_1431().equals(profile.getKey())) availableProfileKeys.remove(profileKey);
            }
        }
        return availableProfileKeys;
    }

    private static void save() {
        JsonObject jsonObject = FileHandler.get(PROFILES_PATH).isJsonObject() ? FileHandler.get(PROFILES_PATH).getAsJsonObject() : new JsonObject();
        jsonObject.remove(InventiveInventory.getWorldName());
        jsonObject.add(InventiveInventory.getWorldName(), profilesToJson());
        FileHandler.write(ProfileHandler.PROFILES_PATH, jsonObject);
    }

    private static List<SavedSlot> createSavedSlots() {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        List<SavedSlot> savedSlots = new ArrayList<>();
        if (screenHandler == null) return savedSlots;
        for (int slot : PlayerSlots.get(SlotTypes.HOTBAR, SlotTypes.OFFHAND)) {
            class_1799 stack = screenHandler.method_7611(slot).method_7677().method_7972();
            if (!stack.method_7960()) savedSlots.add(new SavedSlot(slot, stack));
        }
        return savedSlots;
    }

    public static void init() {
        profiles.clear();
        for (JsonElement jsonElement : getJsonProfiles()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            int id = jsonObject.getAsJsonPrimitive("id").getAsInt();
            String name = jsonObject.getAsJsonPrimitive("name").getAsString();
            String key = jsonObject.getAsJsonPrimitive("key").getAsString();
            JsonObject displayStack = jsonObject.getAsJsonObject("display_stack");
            JsonArray savedSlots = jsonObject.getAsJsonArray("saved_slots");
            profiles.add(new Profile(id, name, key, displayStack, savedSlots));
        }
    }

    private static JsonArray getJsonProfiles() {
        return FileHandler.get(PROFILES_PATH).isJsonObject() && FileHandler.get(PROFILES_PATH).getAsJsonObject().has(InventiveInventory.getWorldName()) ? FileHandler.get(PROFILES_PATH).getAsJsonObject().getAsJsonArray(InventiveInventory.getWorldName()) : new JsonArray();
    }

    private static JsonArray profilesToJson() {
        JsonArray jsonArray = new JsonArray();
        for (Profile profile : profiles) {
            jsonArray.add(profile.getAsJsonObject());
        }
        return jsonArray;
    }
}
