package net.inventive_mods.inventive_inventory.features.profiles.gui.widgets;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.gui.ProfilesScreen;
import net.inventive_mods.inventive_inventory.util.Textures;
import net.inventive_mods.inventive_inventory.util.mouse.MouseLocation;
import net.inventive_mods.inventive_inventory.util.tooltips.TooltipBuilder;
import net.inventive_mods.inventive_inventory.util.tooltips.TooltipType;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_332;
import java.util.List;

public class Section {
    private final int ID;
    private final Profile profile;
    private int iconX;
    private int iconY;

    public Section(int ID, Profile profile) {
        this.ID = ID;
        this.profile = profile;
    }

    public Profile getProfile() {
        return profile;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return MouseLocation.getHoveredProfileSection(mouseX, mouseY) == this.ID;
    }

    public void drawBackground(class_287 builder, boolean hovered) {
        int startAngle = 360 / ProfilesScreen.getSections().size() * this.ID;
        int limit = 360 / ProfilesScreen.getSections().size() + startAngle;
        int centerX = InventiveInventory.getScreen().field_22789 / 2;
        int centerY = InventiveInventory.getScreen().field_22790 / 2;

        int innerRadius = ProfilesScreen.RADIUS / 2;

        int color = hovered ? ProfilesScreen.HOVER_COLOR : ProfilesScreen.COLOR;
        if (this.profile != null && hovered) {
            if (ProfilesScreen.DELETE_KEY_PRESSED) {
                color = ProfilesScreen.DELETE_COLOR;
            } else if (ProfilesScreen.OVERWRITE_KEY_PRESSED) {
                color = ProfilesScreen.OVERWRITE_COLOR;
            }
        }

        for (; startAngle < limit; startAngle++) {
            double angle = (startAngle * Math.PI) / 180;
            double nextAngle = ((startAngle + 1) * Math.PI) / 180;

            float posX = centerX + (float) Math.sin(angle) * ProfilesScreen.RADIUS;
            float posY = centerY - (float) Math.cos(angle) * ProfilesScreen.RADIUS;

            float posInnerX = centerX + (float) Math.sin(angle) * innerRadius;
            float posInnerY = centerY - (float) Math.cos(angle) * innerRadius;

            float nextPosX = centerX + (float) Math.sin(nextAngle) * ProfilesScreen.RADIUS;
            float nextPosY = centerY - (float) Math.cos(nextAngle) * ProfilesScreen.RADIUS;

            float nextPosInnerX = centerX + (float) Math.sin(nextAngle) * innerRadius;
            float nextPosInnerY = centerY - (float) Math.cos(nextAngle) * innerRadius;

            builder.method_22912(posX, posY, 0).method_39415(color).method_1344();
            builder.method_22912(posInnerX, posInnerY, 0).method_39415(color).method_1344();
            builder.method_22912(nextPosInnerX, nextPosInnerY, 0).method_39415(color).method_1344();
            builder.method_22912(nextPosX, nextPosY, 0).method_39415(color).method_1344();
        }
    }

    public void drawIcon(class_332 context) {
        int startAngle = 360 / ProfilesScreen.getSections().size() * this.ID;
        int limit = 360 / ProfilesScreen.getSections().size() + startAngle;
        int centerX = InventiveInventory.getScreen().field_22789 / 2;
        int centerY = InventiveInventory.getScreen().field_22790 / 2;

        int innerRadius = ProfilesScreen.RADIUS / 2;

        int middleAngle = startAngle + (limit - startAngle) / 2;
        double middleRadian = (middleAngle * Math.PI) / 180;

        int middleX = (int) (centerX + Math.sin(middleRadian) * (ProfilesScreen.RADIUS - ((double) (ProfilesScreen.RADIUS - innerRadius) / 2)));
        int middleY = (int) (centerY - Math.cos(middleRadian) * (ProfilesScreen.RADIUS - ((double) (ProfilesScreen.RADIUS - innerRadius) / 2)));

        this.iconX = middleX - 8;
        this.iconY = middleY - 8;

        if (this.profile == null) {
            context.method_25291(Textures.PLUS, iconX, iconY, 0, 0, 0, 16, 16, 16, 16);
        } else if (this.profile.getDisplayStack().method_7960()) {
            context.method_25291(Textures.TOOLS, iconX, iconY, 0, 0, 0, 16, 16, 16, 16);
        } else context.method_51427(this.profile.getDisplayStack(), iconX, iconY);
    }

    public void drawTooltips(class_332 context, int mouseX, int mouseY) {
        boolean inX = this.iconX < mouseX && mouseX < this.iconX + 16;
        boolean inY = this.iconY < mouseY && mouseY < this.iconY + 16;
        boolean isMouseOverIcon = inX && inY;
        if (isMouseOverIcon) {
            List<class_2561> textList;
            if (this.profile != null) {
                if (!this.profile.getName().isEmpty()) textList = TooltipBuilder.of(TooltipType.NAME, this.profile);
                else if (!this.profile.getDisplayStack().method_7960())
                    textList = TooltipBuilder.of(TooltipType.ITEM, this.profile);
                else textList = TooltipBuilder.of(TooltipType.UNKNOWN, this.profile);
            } else textList = TooltipBuilder.of(TooltipType.PLUS, null);
            context.method_51434(InventiveInventory.getClient().field_1772, textList, mouseX, mouseY);
        }
    }
}
