package net.inventive_mods.inventive_inventory.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.inventive_mods.inventive_inventory.features.profiles.SavedSlot;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_6880;
import java.util.ArrayList;
import java.util.List;

public class Converter {
    public static JsonObject itemStackToJson(class_1799 stack) {
        JsonObject stackJson = new JsonObject();
        if (stack == null) return stackJson;
        stackJson.addProperty("id", class_1792.method_7880(stack.method_7909()));

        JsonObject componentsJson = new JsonObject();
        class_2487 nbt = stack.method_7969();
        if (nbt == null) return stackJson;
        if (nbt.method_10545("custom_name")) {
            componentsJson.addProperty("custom_name", nbt.method_10558("custom_name"));
        }

        if (nbt.method_10545("Enchantments")) {
            JsonArray enchantments = new JsonArray();
            class_2499 enchantmentsNbtList = nbt.method_10554("Enchantments", 10);
            for (class_2520 enchantmentElement : enchantmentsNbtList) {
                class_2487 enchantmentCompound = (class_2487) enchantmentElement;
                JsonObject enchantment = new JsonObject();
                enchantment.addProperty("id", enchantmentCompound.method_10558("id"));
                enchantment.addProperty("lvl", enchantmentCompound.method_10568("lvl"));
                enchantments.add(enchantment);
            }
            componentsJson.add("Enchantments", enchantments);
        }

        if (nbt.method_10545("Potion")) {
            componentsJson.addProperty("potion", nbt.method_10558("Potion"));
        }

        stackJson.add("components", componentsJson);
        return stackJson;
    }

    public static class_1799 jsonToItemStack(JsonObject stackJson) {
        if (stackJson.get("id") == null) return null;
        class_1799 item = new class_1799(class_6880.method_40223(class_1792.method_7875(stackJson.get("id").getAsInt())));

        class_2487 nbt = new class_2487();
        JsonObject components = stackJson.getAsJsonObject("components");
        if (components == null) return item;

        if (components.has("custom_name")) {
            nbt.method_10582("custom_name", components.get("custom_name").getAsString());
        }

        if (components.has("Enchantments")) {
            JsonArray enchantmentsJson = components.getAsJsonArray("Enchantments");
            class_2499 enchantments = new class_2499();
            for (JsonElement enchantmentElement : enchantmentsJson) {
                JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                class_2487 enchantment = new class_2487();
                enchantment.method_10582("id", enchantmentObject.get("id").getAsString());
                enchantment.method_10569("lvl", enchantmentObject.get("lvl").getAsInt());
                enchantments.add(enchantment);
            }
            nbt.method_10566("Enchantments", enchantments);
        }

        if (components.has("potion")) {
            nbt.method_10582("Potion", components.get("potion").getAsString());
        }

        item.method_7980(nbt);
        return item;
    }

    public static List<SavedSlot> jsonToSavedSlots(JsonArray savedSlotsJson) {
        List<SavedSlot> savedSlotList = new ArrayList<>();
        for (JsonElement savedSlotElement : savedSlotsJson) {
            JsonObject savedSlotObject = savedSlotElement.getAsJsonObject();
            int slot = savedSlotObject.get("slot").getAsInt();
            class_1799 stack = Converter.jsonToItemStack(savedSlotObject.getAsJsonObject("stack"));
            savedSlotList.add(new SavedSlot(slot, stack));
        }
        return savedSlotList;
    }
}
